/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.model;

import java.io.File;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.model.Source;

public class LocalSource
extends Source<File> {
    private File theFile = null;

    public LocalSource(File theFile) throws InvalidSourceException {
        if (theFile == null) {
            throw new InvalidSourceException("File cannot be null");
        }
        this.theFile = theFile;
    }

    @Override
    public boolean validate() throws InvalidSourceException {
        if (!this.theFile.exists()) {
            throw new InvalidSourceException("File " + this.theFile.getAbsolutePath() + "doesn't exist");
        }
        if (!this.theFile.canRead()) {
            throw new InvalidSourceException("Unable to read from file " + this.theFile.getAbsolutePath());
        }
        if (this.theFile.isDirectory()) {
            throw new InvalidSourceException("Transfer of directory is not yet supported");
        }
        return true;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void clean() {
    }

    @Override
    public File getTheSource() {
        return this.theFile;
    }
}

