/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.ManagedException;
import org.gcube.data.transfer.service.transfers.engine.faults.NotSupportedMethodException;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private TransferTicket ticket;
    private TicketManager manager;

    public RequestHandler(TransferRequest servingRequest, TicketManager manager) {
        this.ticket = new TransferTicket(servingRequest);
        log.debug("Created Handler, request is : " + servingRequest);
        this.manager = manager;
        manager.insertUpdate(this.ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.trace("Request handling started. Ticket is " + this.ticket);
            switch (1.$SwitchMap$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod[this.ticket.getSettings().getOptions().getMethod().ordinal()]) {
                case 1: {
                    throw new NotSupportedMethodException("Unable to manage request [ID " + this.ticket.getId() + "]. Method not supported : " + this.ticket.getSettings().getOptions().getMethod());
                }
                case 2: {
                    File output = null;
                    BufferedInputStream in = null;
                    BufferedOutputStream out = null;
                    boolean complete = false;
                    try {
                        this.updateTicket("Opening connection", 0.0, TransferTicket.Status.TRANSFERRING, 0L);
                        HttpDownloadSettings options = (HttpDownloadSettings)this.ticket.getSettings();
                        log.debug("HttpDownload, opening channel");
                        try {
                            output = File.createTempFile("http_", "");
                            out = new BufferedOutputStream(new FileOutputStream(output));
                        }
                        catch (IOException e) {
                            log.warn("Unable to create destination file.", (Throwable)e);
                            throw new ManagedException("Cannot save file in host");
                        }
                        log.debug("Opening read buffer " + options.getSource().toString());
                        this.ticket.setDestinationFileName(output.getAbsolutePath());
                        try {
                            in = new BufferedInputStream(options.getSource().openStream());
                        }
                        catch (Exception e) {
                            log.debug("Unable to open connection ", (Throwable)e);
                            throw new ManagedException("Cannot open connection to source");
                        }
                        try {
                            long receivedTotal = 0L;
                            byte[] internalBuf = new byte[1024];
                            int received = 0;
                            while ((received = in.read(internalBuf)) != -1) {
                                out.write(internalBuf);
                                this.updateTicket("Transferring", 0.0, TransferTicket.Status.TRANSFERRING, receivedTotal += (long)received);
                            }
                        }
                        catch (IOException e) {
                            log.debug("Unable to read from source", (Throwable)e);
                            throw new ManagedException("Unable to read from source.");
                        }
                        complete = true;
                    }
                    finally {
                        if (!complete && output != null) {
                            Files.deleteIfExists(null);
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    this.updateTicket("Completed transfer", 1.0, TransferTicket.Status.SUCCESS);
                }
            }
        }
        catch (NotSupportedMethodException e) {
            this.setError(e.getMessage());
        }
        catch (ManagedException e) {
            this.setError(e.getMessage());
        }
        catch (Throwable t) {
            this.setError("Unexpected error while downloading : " + t.getMessage());
            log.error("Unexpected error occurred", t);
        }
    }

    private void setError(String message) {
        this.updateTicket(message, this.ticket.getPercent(), TransferTicket.Status.ERROR);
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status) {
        this.updateTicket(message, percent, status, this.ticket.getTransferredBytes());
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status, long readBytes) {
        this.ticket.setStatus(status);
        this.ticket.setMessage(message);
        this.ticket.setPercent(percent);
        this.ticket.setTransferredBytes(readBytes);
        this.manager.insertUpdate(this.ticket);
    }
}

