/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.PluginDescription;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.AbstractPluginFactory;
import org.gcube.data.transfer.plugin.ExecutionReport;
import org.gcube.data.transfer.plugin.fails.PluginException;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.faults.PluginExecutionException;
import org.gcube.data.transfer.service.transfers.engine.faults.PluginNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class PluginManagerImpl
implements PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManagerImpl.class);
    private static final Object $LOCK = new Object[0];
    private static ServiceLoader<AbstractPluginFactory> abstractFactoryLoader = null;
    private static Map<String, PluginDescription> installedPlugins = null;

    public Map<String, PluginDescription> getInstalledPlugins() {
        return PluginManagerImpl.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PluginDescription> init() {
        Object object = $LOCK;
        synchronized (object) {
            if (installedPlugins == null) {
                HashMap<String, PluginDescription> toSet = new HashMap<String, PluginDescription>();
                log.trace("Loading plugins descriptors..");
                for (AbstractPluginFactory factory : abstractFactoryLoader) {
                    log.debug("loading {}, {} ", (Object)factory.getID(), (Object)factory.getDescription());
                    toSet.put(factory.getID(), new PluginDescription(factory.getID(), factory.getDescription(), factory.getParameters()));
                }
                installedPlugins = toSet;
            }
            return installedPlugins;
        }
    }

    public ExecutionReport execute(PluginInvocation invocation) throws PluginNotFoundException, PluginExecutionException {
        log.debug("Executing invocation {} ", (Object)invocation);
        AbstractPluginFactory factory = this.getFactory(invocation.getPluginId());
        log.debug("Loaded factory {} ", factory.getClass());
        log.debug("Checkign invocation .. ");
        try {
            factory.checkInvocation(invocation);
            AbstractPlugin plugin = factory.createWorker(invocation);
            return plugin.execute();
        }
        catch (PluginException e) {
            throw new PluginExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private AbstractPluginFactory getFactory(String pluginId) throws PluginNotFoundException {
        for (AbstractPluginFactory factory : abstractFactoryLoader) {
            if (!factory.getID().equals(pluginId)) continue;
            return factory;
        }
        throw new PluginNotFoundException("Plugin with ID " + pluginId + " not found");
    }

    static {
        abstractFactoryLoader = ServiceLoader.load(AbstractPluginFactory.class);
    }
}

