/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.JsonCursor;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.io.IOException;
import java.io.StringWriter;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

class OperatorExportToGeoJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    int m_index = -1;
    int m_wkid = -1;
    int m_latest_wkid = -1;
    String m_wkt = null;
    boolean m_preferMulti = false;
    private static JsonFactory factory = new JsonFactory();

    public OperatorExportToGeoJsonCursor(boolean preferMulti, SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        if (spatialReference != null && !spatialReference.isLocal()) {
            this.m_wkid = spatialReference.getOldID();
            this.m_wkt = spatialReference.getText();
            this.m_latest_wkid = spatialReference.getLatestID();
        }
        this.m_inputGeometryCursor = geometryCursor;
        this.m_preferMulti = preferMulti;
    }

    public OperatorExportToGeoJsonCursor(GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeometryCursor = geometryCursor;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return this.exportToGeoJson(geometry);
        }
        return null;
    }

    private String exportToGeoJson(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator g = factory.createJsonGenerator(sw);
            int type = geometry.getType().value();
            switch (type) {
                case 33: {
                    this.exportPointToGeoJson(g, (Point)geometry);
                    break;
                }
                case 550: {
                    this.exportMultiPointToGeoJson(g, (MultiPoint)geometry);
                    break;
                }
                case 1607: {
                    this.exportMultiPathToGeoJson(g, (Polyline)geometry);
                    break;
                }
                case 1736: {
                    this.exportMultiPathToGeoJson(g, (Polygon)geometry);
                    break;
                }
                case 197: {
                    this.exportEnvelopeToGeoJson(g, (Envelope)geometry);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented for this geometry type");
                }
            }
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void exportPointToGeoJson(JsonGenerator g, Point p) throws JsonGenerationException, IOException {
        if (this.m_preferMulti) {
            MultiPoint mp = new MultiPoint();
            mp.add(p);
            this.exportMultiPointToGeoJson(g, mp);
            return;
        }
        g.writeStartObject();
        g.writeFieldName("type");
        g.writeString("Point");
        g.writeFieldName("coordinates");
        if (p.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            this.writeDouble(p.getX(), g);
            this.writeDouble(p.getY(), g);
            if (p.hasAttribute(1)) {
                this.writeDouble(p.getZ(), g);
            }
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPointToGeoJson(JsonGenerator g, MultiPoint mp) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeFieldName("type");
        g.writeString("MultiPoint");
        g.writeFieldName("coordinates");
        if (mp.isEmpty()) {
            g.writeNull();
        } else {
            g.writeStartArray();
            MultiPointImpl mpImpl = (MultiPointImpl)mp._getImpl();
            AttributeStreamOfDbl zs = mp.hasAttribute(1) ? (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1) : null;
            Point2D p = new Point2D();
            int n = mp.getPointCount();
            for (int i = 0; i < n; ++i) {
                mp.getXY(i, p);
                g.writeStartArray();
                this.writeDouble(p.x, g);
                this.writeDouble(p.y, g);
                if (zs != null) {
                    this.writeDouble(zs.get(i), g);
                }
                g.writeEndArray();
            }
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPathToGeoJson(JsonGenerator g, MultiPath p) throws JsonGenerationException, IOException {
        MultiPathImpl pImpl = (MultiPathImpl)p._getImpl();
        boolean isPolygon = pImpl.m_bPolygon;
        int polyCount = isPolygon ? pImpl.getOGCPolygonCount() : 0;
        g.writeStartObject();
        g.writeFieldName("type");
        boolean bCollection = false;
        if (isPolygon) {
            if (polyCount >= 2 || this.m_preferMulti) {
                g.writeString("MultiPolygon");
                bCollection = true;
            } else {
                g.writeString("Polygon");
            }
        } else if (p.getPathCount() > 1 || this.m_preferMulti) {
            g.writeString("MultiLineString");
            bCollection = true;
        } else {
            g.writeString("LineString");
        }
        g.writeFieldName("coordinates");
        if (p.isEmpty()) {
            g.writeNull();
        } else {
            this.exportMultiPathToGeoJson(g, pImpl, bCollection);
        }
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPathToGeoJson(JsonGenerator g, MultiPathImpl pImpl, boolean bCollection) throws IOException {
        if (bCollection) {
            g.writeStartArray();
        }
        int pathCount = pImpl.getPathCount();
        boolean isPolygon = pImpl.m_bPolygon;
        AttributeStreamOfDbl zs = pImpl.hasAttribute(1) ? (AttributeStreamOfDbl)pImpl.getAttributeStreamRef(1) : null;
        for (int path = 0; path < pathCount; ++path) {
            boolean isExtRing;
            int startIndex = pImpl.getPathStart(path);
            int vertices = pImpl.getPathSize(path);
            boolean bl = isExtRing = isPolygon && pImpl.isExteriorRing(path);
            if (isExtRing) {
                if (path > 0) {
                    g.writeEndArray();
                }
                g.writeStartArray();
            }
            this.writePath(pImpl, g, path, startIndex, vertices, zs);
        }
        if (isPolygon) {
            g.writeEndArray();
        }
        if (bCollection) {
            g.writeEndArray();
        }
    }

    private void closePath(MultiPathImpl mp, JsonGenerator g, int startIndex, AttributeStreamOfDbl zs) throws IOException {
        Point2D pt = new Point2D();
        mp.getXY(startIndex, pt);
        g.writeStartArray();
        this.writeDouble(pt.x, g);
        this.writeDouble(pt.y, g);
        if (zs != null) {
            this.writeDouble(zs.get(startIndex), g);
        }
        g.writeEndArray();
    }

    private void writePath(MultiPathImpl mp, JsonGenerator g, int pathIndex, int startIndex, int vertices, AttributeStreamOfDbl zs) throws IOException {
        Point2D pt = new Point2D();
        g.writeStartArray();
        for (int i = startIndex; i < startIndex + vertices; ++i) {
            mp.getXY(i, pt);
            g.writeStartArray();
            this.writeDouble(pt.x, g);
            this.writeDouble(pt.y, g);
            if (zs != null) {
                this.writeDouble(zs.get(i), g);
            }
            g.writeEndArray();
        }
        if (mp.isClosedPath(pathIndex)) {
            this.closePath(mp, g, startIndex, zs);
        }
        g.writeEndArray();
    }

    private void exportEnvelopeToGeoJson(JsonGenerator g, Envelope e) throws JsonGenerationException, IOException {
        boolean empty = e.isEmpty();
        g.writeStartObject();
        g.writeFieldName("bbox");
        if (empty) {
            g.writeNull();
        } else {
            g.writeStartArray();
            this.writeDouble(e.getXMin(), g);
            this.writeDouble(e.getYMin(), g);
            this.writeDouble(e.getXMax(), g);
            this.writeDouble(e.getYMax(), g);
            g.writeEndArray();
        }
        g.writeEndObject();
        g.close();
    }

    private void writeDouble(double d, JsonGenerator g) throws IOException, JsonGenerationException {
        if (NumberUtils.isNaN(d)) {
            g.writeNull();
        } else {
            g.writeNumber(d);
        }
    }
}

