/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.MultiValuedAssociation;
import org.apache.sis.feature.SingletonAssociation;
import org.apache.sis.feature.Validator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractAssociation
extends Field<AbstractFeature>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5992169056331267867L;
    final DefaultAssociationRole role;

    protected AbstractAssociation(DefaultAssociationRole role) {
        this.role = role;
    }

    public static AbstractAssociation create(DefaultAssociationRole role) {
        ArgumentChecks.ensureNonNull("role", role);
        return AbstractAssociation.isSingleton(role.getMaximumOccurs()) ? new SingletonAssociation(role) : new MultiValuedAssociation(role);
    }

    static AbstractAssociation create(DefaultAssociationRole role, Object value) {
        ArgumentChecks.ensureNonNull("role", role);
        return AbstractAssociation.isSingleton(role.getMaximumOccurs()) ? new SingletonAssociation(role, (AbstractFeature)value) : new MultiValuedAssociation(role, value);
    }

    @Override
    public GenericName getName() {
        return this.role.getName();
    }

    public DefaultAssociationRole getRole() {
        return this.role;
    }

    @Override
    public abstract AbstractFeature getValue() throws IllegalStateException;

    @Override
    public Collection<AbstractFeature> getValues() {
        return super.getValues();
    }

    @Override
    public abstract void setValue(AbstractFeature var1) throws IllegalArgumentException;

    @Override
    public void setValues(Collection<? extends AbstractFeature> values) throws IllegalArgumentException {
        super.setValues(values);
    }

    final void ensureValid(DefaultFeatureType base, DefaultFeatureType type) {
        if (base != type && !DefaultFeatureType.maybeAssignableFrom(base, type)) {
            throw new IllegalArgumentException(Errors.format((short)29, this.getName(), base.getName(), type.getName()));
        }
    }

    public DataQuality quality() {
        Validator v = new Validator(null);
        v.validate(this.role, this.getValues());
        return v.quality;
    }

    public String toString() {
        final String pt = DefaultAssociationRole.getTitleProperty(this.role);
        final Iterator<AbstractFeature> it = this.getValues().iterator();
        return FieldType.toString("FeatureAssociation", (AbstractIdentifiedType)this.role, DefaultAssociationRole.getValueTypeName(this.role), new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Object next() {
                return ((AbstractFeature)it.next()).getPropertyValue(pt);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }).toString();
    }

    public AbstractAssociation clone() throws CloneNotSupportedException {
        return (AbstractAssociation)super.clone();
    }
}

