/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -5637918246427380190L;
    final DefaultFeatureType type;

    protected AbstractFeature(DefaultFeatureType type) {
        ArgumentChecks.ensureNonNull("type", type);
        this.type = type;
    }

    final String getName() {
        return String.valueOf(this.type.getName());
    }

    public DefaultFeatureType getType() {
        return this.type;
    }

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract void setProperty(Object var1) throws IllegalArgumentException;

    final Property createProperty(String name, Object value) {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return AbstractAttribute.create((DefaultAttributeType)pt, value);
        }
        if (pt instanceof DefaultAssociationRole) {
            return AbstractAssociation.create((DefaultAssociationRole)pt, value);
        }
        throw new CorruptedObjectException(Errors.format((short)118, pt));
    }

    final Property createProperty(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return ((DefaultAttributeType)pt).newInstance();
        }
        if (pt instanceof DefaultAssociationRole) {
            return ((DefaultAssociationRole)pt).newInstance();
        }
        throw AbstractFeature.unsupportedPropertyType(pt.getName());
    }

    final Object getOperationResult(String name) {
        assert (DefaultFeatureType.OPERATION_INDEX.equals(this.type.indices().get(name))) : name;
        return ((AbstractOperation)this.type.getProperty(name)).apply(this, null);
    }

    final Object getOperationValue(String name) {
        AbstractOperation operation = (AbstractOperation)this.type.getProperty(name);
        if (operation instanceof LinkOperation) {
            return this.getPropertyValue(((LinkOperation)operation).referentName);
        }
        Object result = operation.apply(this, null);
        if (result instanceof AbstractAttribute) {
            return AbstractFeature.getAttributeValue((AbstractAttribute)result);
        }
        if (result instanceof AbstractAssociation) {
            return AbstractFeature.getAssociationValue((AbstractAssociation)result);
        }
        return null;
    }

    final void setOperationValue(String name, Object value) {
        AbstractOperation operation = (AbstractOperation)this.type.getProperty(name);
        if (operation instanceof LinkOperation) {
            this.setPropertyValue(((LinkOperation)operation).referentName, value);
        } else {
            Object result = operation.apply(this, null);
            if (result instanceof Property) {
                AbstractFeature.setPropertyValue((Property)result, value);
            } else {
                throw new IllegalStateException(Errors.format((short)11, name));
            }
        }
    }

    final Object getDefaultValue(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return AbstractFeature.getDefaultValue((DefaultAttributeType)pt);
        }
        if (pt instanceof DefaultAssociationRole) {
            int maximumOccurs = ((DefaultAssociationRole)pt).getMaximumOccurs();
            return maximumOccurs > 1 ? Collections.EMPTY_LIST : null;
        }
        throw AbstractFeature.unsupportedPropertyType(pt.getName());
    }

    private static <V> Object getDefaultValue(DefaultAttributeType<V> attribute) {
        V defaultValue = attribute.getDefaultValue();
        if (Field.isSingleton(attribute.getMaximumOccurs())) {
            return defaultValue;
        }
        return defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
    }

    public abstract Object getPropertyValue(String var1) throws IllegalArgumentException;

    public abstract void setPropertyValue(String var1, Object var2) throws IllegalArgumentException;

    static Object getAttributeValue(AbstractAttribute<?> property) {
        return Field.isSingleton(property.getType().getMaximumOccurs()) ? property.getValue() : property.getValues();
    }

    static Object getAssociationValue(AbstractAssociation property) {
        return Field.isSingleton(property.getRole().getMaximumOccurs()) ? property.getValue() : property.getValues();
    }

    static void setPropertyValue(Property property, Object value) {
        if (property instanceof AbstractAttribute) {
            AbstractFeature.setAttributeValue((AbstractAttribute)property, value);
        } else if (property instanceof AbstractAssociation) {
            AbstractFeature.setAssociationValue((AbstractAssociation)property, value);
        } else {
            throw AbstractFeature.unsupportedPropertyType(property.getName());
        }
    }

    private static <V> void setAttributeValue(AbstractAttribute<V> attribute, Object value) {
        DefaultAttributeType<V> pt;
        Class<V> base;
        if (value != null && !(base = (pt = attribute.getType()).getValueClass()).isInstance(value)) {
            Object element = value;
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                do {
                    if (it.hasNext()) continue;
                    attribute.setValues((Collection)value);
                    return;
                } while ((element = it.next()) == null || base.isInstance(element));
            }
            throw AbstractFeature.illegalValueClass(attribute.getName(), element);
        }
        attribute.setValue(value);
    }

    private static void setAssociationValue(AbstractAssociation association, Object value) {
        if (value != null) {
            DefaultAssociationRole role = association.getRole();
            DefaultFeatureType base = role.getValueType();
            if (value instanceof AbstractFeature) {
                DefaultFeatureType actual = ((AbstractFeature)value).getType();
                if (base != actual && !DefaultFeatureType.maybeAssignableFrom(base, actual)) {
                    throw AbstractFeature.illegalPropertyType(role.getName(), actual.getName());
                }
            } else {
                if (value instanceof Collection) {
                    AbstractFeature.verifyAssociationValues(role, (Collection)value);
                    association.setValues((Collection)value);
                    return;
                }
                throw AbstractFeature.illegalValueClass(association.getName(), value);
            }
        }
        association.setValue((AbstractFeature)value);
    }

    static boolean canSkipVerification(Object previous, Object value) {
        if (previous != null) {
            if (value == null) {
                return true;
            }
            if (previous.getClass() == value.getClass() && !(value instanceof AbstractFeature)) {
                return true;
            }
        }
        return false;
    }

    final void verifyPropertyType(String name, Property property) {
        FieldType pt;
        AbstractIdentifiedType base = this.type.getProperty(name);
        if (property instanceof AbstractAttribute) {
            pt = ((AbstractAttribute)property).getType();
        } else if (property instanceof AbstractAssociation) {
            pt = ((AbstractAssociation)property).getRole();
        } else {
            throw AbstractFeature.illegalPropertyType(base.getName(), property.getClass());
        }
        if (pt != base) {
            if (base == null) {
                throw new IllegalArgumentException(Errors.format((short)71, this.getName(), name));
            }
            throw new IllegalArgumentException(Errors.format((short)154, name));
        }
    }

    final Object verifyPropertyValue(String name, Object value) {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            if (value != null) {
                return AbstractFeature.verifyAttributeValue((DefaultAttributeType)pt, value);
            }
        } else if (pt instanceof DefaultAssociationRole) {
            if (value != null) {
                return AbstractFeature.verifyAssociationValue((DefaultAssociationRole)pt, value);
            }
        } else {
            throw AbstractFeature.unsupportedPropertyType(pt.getName());
        }
        return value;
    }

    private static <T> Object verifyAttributeValue(DefaultAttributeType<T> type, Object value) {
        Class<T> valueClass = type.getValueClass();
        boolean isSingleton = Field.isSingleton(type.getMaximumOccurs());
        if (valueClass.isInstance(value)) {
            return isSingleton ? value : AbstractFeature.singletonList(valueClass, type.getMinimumOccurs(), value);
        }
        if (!isSingleton && value instanceof Collection) {
            return CheckedArrayList.castOrCopy(value, valueClass);
        }
        throw AbstractFeature.illegalValueClass(type.getName(), value);
    }

    private static Object verifyAssociationValue(DefaultAssociationRole role, Object value) {
        boolean isSingleton = Field.isSingleton(role.getMaximumOccurs());
        if (value instanceof AbstractFeature) {
            DefaultFeatureType valueType = ((AbstractFeature)((Object)value)).getType();
            DefaultFeatureType base = role.getValueType();
            if (base == valueType || DefaultFeatureType.maybeAssignableFrom(base, valueType)) {
                return isSingleton ? value : AbstractFeature.singletonList(AbstractFeature.class, role.getMinimumOccurs(), value);
            }
            throw AbstractFeature.illegalPropertyType(role.getName(), valueType.getName());
        }
        if (!isSingleton && value instanceof Collection) {
            AbstractFeature.verifyAssociationValues(role, value);
            return CheckedArrayList.castOrCopy(value, AbstractFeature.class);
        }
        throw AbstractFeature.illegalValueClass(role.getName(), value);
    }

    private static void verifyAssociationValues(DefaultAssociationRole role, Collection<?> values) {
        DefaultFeatureType base = role.getValueType();
        int index = 0;
        for (Object value : values) {
            ArgumentChecks.ensureNonNullElement("values", index, value);
            if (!(value instanceof AbstractFeature)) {
                throw AbstractFeature.illegalValueClass(role.getName(), value);
            }
            DefaultFeatureType type = ((AbstractFeature)value).getType();
            if (base != type && !DefaultFeatureType.maybeAssignableFrom(base, type)) {
                throw AbstractFeature.illegalPropertyType(role.getName(), type.getName());
            }
            ++index;
        }
    }

    private static <V> Collection<V> singletonList(Class<V> valueClass, int minimumOccurs, Object value) {
        CheckedArrayList<V> values = new CheckedArrayList<V>(valueClass, Math.max(minimumOccurs, 4));
        values.add(value);
        return values;
    }

    static IllegalArgumentException unsupportedPropertyType(GenericName name) {
        return new IllegalArgumentException(Errors.format((short)5, name));
    }

    private static ClassCastException illegalValueClass(GenericName name, Object value) {
        return new ClassCastException(Errors.format((short)40, name, value.getClass()));
    }

    private static IllegalArgumentException illegalPropertyType(GenericName name, Object value) {
        return new IllegalArgumentException(Errors.format((short)40, name, value));
    }

    public DataQuality quality() {
        Validator v = new Validator(ScopeCode.FEATURE);
        v.validate(this.type, this);
        return v.quality;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }
}

