/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class AbstractIdentifiedType
implements Serializable {
    private static final long serialVersionUID = 277130188958446740L;
    public static final String NAME_KEY = "name";
    public static final String DEFINITION_KEY = "definition";
    public static final String DESIGNATION_KEY = "designation";
    public static final String DESCRIPTION_KEY = "description";
    private final GenericName name;
    private final InternationalString definition;
    private final InternationalString designation;
    private final InternationalString description;

    protected AbstractIdentifiedType(Map<String, ?> identification) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("identification", identification);
        Object value = identification.get(NAME_KEY);
        if (value == null) {
            throw new IllegalArgumentException(Errors.getResources(identification).getString((short)64, NAME_KEY));
        }
        if (value instanceof String) {
            this.name = this.createName(DefaultFactories.forBuildin(NameFactory.class), (String)value);
        } else if (value instanceof GenericName) {
            this.name = (GenericName)value;
        } else {
            throw new IllegalArgumentException(Errors.getResources(identification).getString((short)40, NAME_KEY, value.getClass()));
        }
        this.definition = Types.toInternationalString(identification, DEFINITION_KEY);
        this.designation = Types.toInternationalString(identification, DESIGNATION_KEY);
        this.description = Types.toInternationalString(identification, DESCRIPTION_KEY);
    }

    GenericName createName(NameFactory factory, String value) {
        return factory.createLocalName(null, value);
    }

    public final GenericName getName() {
        return this.name;
    }

    public InternationalString getDefinition() {
        return this.definition;
    }

    public InternationalString getDesignation() {
        return this.designation;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.definition, this.designation, this.description);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            AbstractIdentifiedType that = (AbstractIdentifiedType)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition) && Objects.equals(this.designation, that.designation) && Objects.equals(this.description, that.description);
        }
        return false;
    }

    static String toString(GenericName name, AbstractIdentifiedType container, String argument, int index) {
        short key = 64;
        if (name != null) {
            String s = name.toString();
            if (!s.isEmpty()) {
                return s;
            }
            key = 23;
        }
        StringBuilder b = new StringBuilder(40).append("Type[\u201c").append(container.getName()).append("\u201d].").append(argument).append('[').append(index).append("].name");
        throw new IllegalArgumentException(Errors.format(key, b.toString()));
    }
}

