/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.referencing.IdentifiedObjects;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class AbstractOperation
extends AbstractIdentifiedType {
    private static final long serialVersionUID = -179930765502963170L;
    static final String RESULT_PREFIX = "result.";

    public AbstractOperation(Map<String, ?> identification) {
        super(identification);
    }

    final Map<String, Object> resultIdentification(Map<String, ?> identification) {
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, ?> entry : identification.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith(RESULT_PREFIX)) continue;
            properties.put(key.substring(RESULT_PREFIX.length()), entry.getValue());
        }
        if (properties.isEmpty()) {
            properties.put("name", super.getName());
            properties.put("definition", super.getDefinition());
            properties.put("designation", super.getDesignation());
            properties.put("description", super.getDescription());
        }
        return properties;
    }

    public abstract ParameterDescriptorGroup getParameters();

    public abstract AbstractIdentifiedType getResult();

    public abstract Object apply(AbstractFeature var1, ParameterValueGroup var2);

    public Set<String> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.getParameters()) + Objects.hashCode(this.getResult());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            AbstractOperation that = (AbstractOperation)obj;
            return Objects.equals(this.getParameters(), that.getParameters()) && Objects.equals(this.getResult(), that.getResult());
        }
        return false;
    }

    public String toString() {
        AbstractIdentifiedType result;
        StringBuilder buffer = new StringBuilder(40).append("Operation").append('[');
        GenericName name = this.getName();
        if (name != null) {
            buffer.append('\u201c');
        }
        buffer.append(name);
        if (name != null) {
            buffer.append('\u201d');
        }
        String separator = " (";
        for (GeneralParameterDescriptor param : this.getParameters().descriptors()) {
            buffer.append(separator).append(IdentifiedObjects.toString(param.getName()));
            separator = ", ";
        }
        if (separator == ", ") {
            buffer.append(')');
        }
        if ((result = this.getResult()) != null) {
            buffer.append(" : ").append(result.getName());
        }
        return buffer.append(']').toString();
    }
}

