/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;

final class CharacteristicTypeMap
extends AbstractMap<String, DefaultAttributeType<?>> {
    private static final WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> SHARED = new WeakValueHashMap(DefaultAttributeType[].class);
    final DefaultAttributeType<?>[] characterizedBy;
    final Map<String, Integer> indices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacteristicTypeMap create(DefaultAttributeType<?> source, DefaultAttributeType<?>[] characterizedBy) {
        CharacteristicTypeMap map;
        WeakValueHashMap<DefaultAttributeType<?>[], CharacteristicTypeMap> weakValueHashMap = SHARED;
        synchronized (weakValueHashMap) {
            map = SHARED.get(characterizedBy);
            if (map == null) {
                map = new CharacteristicTypeMap(source, characterizedBy);
                SHARED.put(characterizedBy, map);
            }
        }
        return map;
    }

    private CharacteristicTypeMap(DefaultAttributeType<?> source, DefaultAttributeType<?>[] characterizedBy) {
        this.characterizedBy = characterizedBy;
        int index = 0;
        HashMap<String, Integer> indices = new HashMap<String, Integer>(Containers.hashMapCapacity(characterizedBy.length));
        for (int i = 0; i < characterizedBy.length; ++i) {
            DefaultAttributeType<?> attribute = characterizedBy[i];
            ArgumentChecks.ensureNonNullElement("characterizedBy", i, attribute);
            String name = AbstractIdentifiedType.toString(attribute.getName(), source, "characterizedBy", i);
            if (indices.put(name, index++) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)17, name));
        }
        this.indices = CollectionsExt.compact(indices);
    }

    @Override
    public boolean isEmpty() {
        return this.characterizedBy.length == 0;
    }

    @Override
    public int size() {
        return this.characterizedBy.length;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indices.containsKey(key);
    }

    @Override
    public boolean containsValue(Object key) {
        for (DefaultAttributeType<?> type : this.characterizedBy) {
            if (!type.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DefaultAttributeType<?> get(Object key) {
        Integer index = this.indices.get(key);
        return index != null ? this.characterizedBy[index] : null;
    }

    @Override
    protected AbstractMap.EntryIterator<String, DefaultAttributeType<?>> entryIterator() {
        return new AbstractMap.EntryIterator<String, DefaultAttributeType<?>>(){
            private int index;
            private DefaultAttributeType<?> value;

            @Override
            protected boolean next() {
                if (this.index < CharacteristicTypeMap.this.characterizedBy.length) {
                    this.value = CharacteristicTypeMap.this.characterizedBy[this.index++];
                    return true;
                }
                return false;
            }

            @Override
            protected String getKey() {
                return this.value.getName().toString();
            }

            @Override
            protected DefaultAttributeType<?> getValue() {
                return this.value;
            }
        };
    }
}

