/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;

public class DefaultAssociationRole
extends FieldType {
    private static final long serialVersionUID = 1592712639262027124L;
    private volatile FeatureType valueType;
    private volatile transient String titleProperty;

    public DefaultAssociationRole(Map<String, ?> identification, DefaultFeatureType valueType, int minimumOccurs, int maximumOccurs) {
        super(identification, minimumOccurs, maximumOccurs);
        ArgumentChecks.ensureNonNull("valueType", valueType);
        this.valueType = valueType;
    }

    public DefaultAssociationRole(Map<String, ?> identification, GenericName valueType, int minimumOccurs, int maximumOccurs) {
        super(identification, minimumOccurs, maximumOccurs);
        ArgumentChecks.ensureNonNull("valueType", valueType);
        this.valueType = new NamedFeatureType(valueType);
    }

    final boolean resolve(DefaultFeatureType creating) {
        FeatureType type = this.valueType;
        if (type instanceof NamedFeatureType) {
            GenericName name = type.getName();
            if (name.equals(creating.getName())) {
                type = creating;
            } else {
                ArrayList<DefaultFeatureType> deferred = new ArrayList<DefaultFeatureType>();
                type = DefaultAssociationRole.search(creating, name, deferred);
                if (type == null && (deferred.isEmpty() || (type = DefaultAssociationRole.deepSearch(deferred, name)) == null)) {
                    return false;
                }
            }
            this.valueType = type;
        }
        return true;
    }

    private static DefaultFeatureType search(DefaultFeatureType feature, GenericName name, List<DefaultFeatureType> deferred) {
        for (AbstractIdentifiedType property : feature.getProperties(false)) {
            FeatureType valueType;
            if (!(property instanceof DefaultAssociationRole) || (valueType = ((DefaultAssociationRole)property).valueType) instanceof NamedFeatureType) continue;
            if (name.equals(valueType.getName())) {
                return (DefaultFeatureType)valueType;
            }
            deferred.add((DefaultFeatureType)valueType);
        }
        for (DefaultFeatureType type : feature.getSuperTypes()) {
            if (name.equals(type.getName())) {
                return type;
            }
            if ((type = DefaultAssociationRole.search(type, name, deferred)) == null) continue;
            return type;
        }
        return null;
    }

    private static DefaultFeatureType deepSearch(List<DefaultFeatureType> deferred, GenericName name) {
        IdentityHashMap<DefaultFeatureType, Boolean> done = new IdentityHashMap<DefaultFeatureType, Boolean>(8);
        int i = 0;
        while (i < deferred.size()) {
            DefaultFeatureType valueType;
            if (done.put(valueType = deferred.get(i++), Boolean.TRUE) != null) continue;
            deferred.subList(0, i).clear();
            valueType = DefaultAssociationRole.search(valueType, name, deferred);
            if (valueType != null) {
                return valueType;
            }
            i = 0;
        }
        return null;
    }

    public final DefaultFeatureType getValueType() {
        FeatureType type = this.valueType;
        if (type instanceof NamedFeatureType) {
            throw new IllegalStateException(Errors.format((short)164, this.getName()));
        }
        return (DefaultFeatureType)type;
    }

    static GenericName getValueTypeName(DefaultAssociationRole role) {
        return role.valueType.getName();
    }

    static String getTitleProperty(DefaultAssociationRole role) {
        String p = role.titleProperty;
        if (p != null) {
            return p.isEmpty() ? null : p;
        }
        p = DefaultAssociationRole.searchTitleProperty(role);
        role.titleProperty = p != null ? p : "";
        return p;
    }

    private static String searchTitleProperty(DefaultAssociationRole role) {
        for (AbstractIdentifiedType type : role.getValueType().getProperties(true)) {
            DefaultAttributeType pt;
            if (!(type instanceof DefaultAttributeType) || (pt = (DefaultAttributeType)type).getMaximumOccurs() == 0 || !CharSequence.class.isAssignableFrom(pt.getValueClass())) continue;
            return pt.getName().toString();
        }
        return null;
    }

    @Override
    public final int getMinimumOccurs() {
        return super.getMinimumOccurs();
    }

    @Override
    public final int getMaximumOccurs() {
        return super.getMaximumOccurs();
    }

    public AbstractAssociation newInstance() {
        return AbstractAssociation.create(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valueType.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultAssociationRole that = (DefaultAssociationRole)obj;
            return this.valueType.equals(that.valueType);
        }
        return false;
    }

    public String toString() {
        return DefaultAssociationRole.toString("FeatureAssociationRole", this, this.valueType.getName()).toString();
    }
}

