/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DenseFeature;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.feature.SparseFeature;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;

public class DefaultFeatureType
extends AbstractIdentifiedType
implements FeatureType {
    private static final long serialVersionUID = -4357370600723922312L;
    private final boolean isAbstract;
    private transient boolean isSimple;
    private transient boolean isSparse;
    private transient boolean isResolved;
    private final Set<DefaultFeatureType> superTypes;
    private transient Set<GenericName> assignableTo;
    private final List<AbstractIdentifiedType> properties;
    private transient Collection<AbstractIdentifiedType> allProperties;
    private transient Map<String, AbstractIdentifiedType> byName;
    private transient Map<String, Integer> indices;
    static final Integer OPERATION_INDEX = -1;

    public DefaultFeatureType(Map<String, ?> identification, boolean isAbstract, DefaultFeatureType[] superTypes, AbstractIdentifiedType ... properties) {
        super(identification);
        ArgumentChecks.ensureNonNull("properties", properties);
        this.isAbstract = isAbstract;
        if (superTypes == null) {
            this.superTypes = Collections.emptySet();
        } else {
            this.superTypes = CollectionsExt.immutableSet(true, superTypes);
            for (FeatureType featureType : this.superTypes) {
                if (!(featureType instanceof NamedFeatureType)) continue;
                throw new IllegalArgumentException(Errors.format((short)164, featureType.getName()));
            }
        }
        switch (properties.length) {
            case 0: {
                this.properties = Collections.emptyList();
                break;
            }
            case 1: {
                this.properties = Collections.singletonList(properties[0]);
                break;
            }
            default: {
                this.properties = UnmodifiableArrayList.wrap(Arrays.copyOf(properties, properties.length, AbstractIdentifiedType[].class));
            }
        }
        this.computeTransientFields();
        this.isResolved = this.resolve(this, null, this.isSimple);
    }

    @Override
    GenericName createName(NameFactory factory, String value) {
        return factory.createTypeName(null, value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTransientFields();
        this.isResolved = this.isSimple;
    }

    private void computeTransientFields() {
        Object tip;
        int capacity = Containers.hashMapCapacity(this.properties.size());
        this.byName = new LinkedHashMap<String, AbstractIdentifiedType>(capacity);
        this.indices = new LinkedHashMap<String, Integer>(capacity);
        this.assignableTo = new HashSet<GenericName>(4);
        this.assignableTo.add(super.getName());
        this.scanPropertiesFrom(this);
        this.allProperties = UnmodifiableArrayList.wrap(this.byName.values().toArray(new AbstractIdentifiedType[this.byName.size()]));
        this.isSimple = true;
        int index = 0;
        int mandatory = 0;
        for (Map.Entry<String, AbstractIdentifiedType> entry : this.byName.entrySet()) {
            int maximumOccurs;
            int minimumOccurs;
            AbstractIdentifiedType property = entry.getValue();
            if (property instanceof DefaultAttributeType) {
                minimumOccurs = ((DefaultAttributeType)property).getMinimumOccurs();
                this.isSimple &= minimumOccurs == (maximumOccurs = ((DefaultAttributeType)property).getMaximumOccurs());
            } else if (property instanceof FieldType) {
                minimumOccurs = ((FieldType)property).getMinimumOccurs();
                maximumOccurs = ((FieldType)property).getMaximumOccurs();
                this.isSimple = false;
            } else {
                if (!DefaultFeatureType.isParameterlessOperation(property)) continue;
                this.indices.put(entry.getKey(), OPERATION_INDEX);
                continue;
            }
            if (maximumOccurs == 0) continue;
            this.isSimple &= maximumOccurs == 1;
            this.indices.put(entry.getKey(), index++);
            if (minimumOccurs == 0) continue;
            ++mandatory;
        }
        LinkedHashMap<String, AbstractIdentifiedType> aliases = new LinkedHashMap<String, AbstractIdentifiedType>();
        for (AbstractIdentifiedType property : this.allProperties) {
            String key;
            GenericName name = property.getName();
            tip = name.tip();
            if (tip == name || (key = tip.toString()) == null || key.isEmpty() || key.equals(name.toString())) continue;
            aliases.put(key, aliases.containsKey(key) ? null : property);
        }
        for (Map.Entry entry : aliases.entrySet()) {
            Integer value;
            AbstractIdentifiedType property = (AbstractIdentifiedType)entry.getValue();
            if (property != null && JDK8.putIfAbsent(this.byName, tip = (String)entry.getKey(), property) == null && (value = this.indices.get(property.getName().toString())) != null && this.indices.put((String)tip, value) != null) {
                throw new AssertionError(tip);
            }
        }
        this.byName = CollectionsExt.compact(this.byName);
        this.indices = CollectionsExt.compact(this.indices);
        this.assignableTo = CollectionsExt.unmodifiableOrCopy(this.assignableTo);
        int n = this.indices.size();
        this.isSparse = n > 24 && mandatory <= n / 2;
    }

    private void scanPropertiesFrom(DefaultFeatureType source) {
        for (DefaultFeatureType parent : source.getSuperTypes()) {
            if (!this.assignableTo.add(parent.getName())) continue;
            this.scanPropertiesFrom(parent);
        }
        int index = -1;
        for (AbstractIdentifiedType property : source.getProperties(false)) {
            ArgumentChecks.ensureNonNullElement("properties", ++index, property);
            String name = DefaultFeatureType.toString(property.getName(), source, "properties", index);
            AbstractIdentifiedType previous = this.byName.put(name, property);
            if (previous == null || DefaultFeatureType.isAssignableIgnoreName(previous, property)) continue;
            GenericName owner = DefaultFeatureType.ownerOf(this, previous);
            throw new IllegalArgumentException(Errors.format((short)156, owner != null ? owner : "?", name));
        }
    }

    private static GenericName ownerOf(DefaultFeatureType type, AbstractIdentifiedType property) {
        if (type.getProperties(false).contains(property)) {
            return type.getName();
        }
        for (DefaultFeatureType superType : type.getSuperTypes()) {
            GenericName owner = DefaultFeatureType.ownerOf(superType, property);
            if (owner == null) continue;
            return owner;
        }
        return null;
    }

    private boolean resolve(DefaultFeatureType feature, Map<FeatureType, Boolean> previous) {
        feature.isResolved = this.resolve(feature, previous, feature.isResolved);
        return feature.isResolved;
    }

    private boolean resolve(DefaultFeatureType feature, Map<FeatureType, Boolean> previous, boolean resolved) {
        if (!resolved) {
            resolved = true;
            for (DefaultFeatureType type : feature.getSuperTypes()) {
                resolved &= this.resolve(type, previous);
            }
            for (AbstractIdentifiedType property : feature.getProperties(false)) {
                Boolean r;
                if (!(property instanceof DefaultAssociationRole)) continue;
                if (!((DefaultAssociationRole)property).resolve(this)) {
                    resolved = false;
                    continue;
                }
                DefaultFeatureType valueType = ((DefaultAssociationRole)property).getValueType();
                if (valueType == this) continue;
                if (previous == null) {
                    previous = new IdentityHashMap<FeatureType, Boolean>(8);
                }
                if ((r = previous.put(valueType, Boolean.FALSE)) == null) {
                    r = this.resolve(valueType, previous);
                    previous.put(valueType, r);
                }
                resolved &= r.booleanValue();
            }
        }
        return resolved;
    }

    private static boolean isParameterlessOperation(AbstractIdentifiedType type) {
        if (type instanceof AbstractOperation) {
            ParameterDescriptorGroup parameters = ((AbstractOperation)type).getParameters();
            return (parameters == null || parameters.descriptors().isEmpty()) && ((AbstractOperation)type).getResult() != null;
        }
        return false;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    final boolean isSparse() {
        return this.isSparse;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    static boolean maybeAssignableFrom(DefaultFeatureType base, DefaultFeatureType type) {
        return type.assignableTo.contains(base.getName());
    }

    @Override
    public boolean isAssignableFrom(DefaultFeatureType type) {
        if (type == this) {
            return true;
        }
        ArgumentChecks.ensureNonNull("type", type);
        if (!DefaultFeatureType.maybeAssignableFrom(this, type)) {
            return false;
        }
        for (Map.Entry<String, AbstractIdentifiedType> entry : this.byName.entrySet()) {
            AbstractIdentifiedType other;
            try {
                other = type.getProperty(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (DefaultFeatureType.isAssignableIgnoreName(entry.getValue(), other)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableIgnoreName(AbstractIdentifiedType base, AbstractIdentifiedType other) {
        if (base != other) {
            FieldType p1;
            FieldType p0;
            if (base instanceof DefaultAttributeType) {
                if (!(other instanceof DefaultAttributeType)) {
                    return false;
                }
                p0 = (DefaultAttributeType)base;
                p1 = (DefaultAttributeType)other;
                if (!((DefaultAttributeType)p0).getValueClass().isAssignableFrom(((DefaultAttributeType)p1).getValueClass()) || ((DefaultAttributeType)p0).getMinimumOccurs() > ((DefaultAttributeType)p1).getMinimumOccurs() || ((DefaultAttributeType)p0).getMaximumOccurs() < ((DefaultAttributeType)p1).getMaximumOccurs()) {
                    return false;
                }
            }
            if (base instanceof DefaultAssociationRole) {
                DefaultFeatureType f1;
                if (!(other instanceof DefaultAssociationRole)) {
                    return false;
                }
                p0 = (DefaultAssociationRole)base;
                p1 = (DefaultAssociationRole)other;
                if (((DefaultAssociationRole)p0).getMinimumOccurs() > ((DefaultAssociationRole)p1).getMinimumOccurs() || ((DefaultAssociationRole)p0).getMaximumOccurs() < ((DefaultAssociationRole)p1).getMaximumOccurs()) {
                    return false;
                }
                DefaultFeatureType f0 = ((DefaultAssociationRole)p0).getValueType();
                if (f0 != (f1 = ((DefaultAssociationRole)p1).getValueType()) && !f0.isAssignableFrom(f1)) {
                    return false;
                }
            }
        }
        return true;
    }

    public final Set<DefaultFeatureType> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public final Collection<AbstractIdentifiedType> getProperties(boolean includeSuperTypes) {
        return includeSuperTypes ? this.allProperties : this.properties;
    }

    public AbstractIdentifiedType getProperty(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.byName.get(name);
        if (pt != null) {
            return pt;
        }
        throw new IllegalArgumentException(Errors.format((short)71, this.getName(), name));
    }

    final Map<String, Integer> indices() {
        return this.indices;
    }

    public AbstractFeature newInstance() throws IllegalStateException {
        if (this.isAbstract) {
            throw new IllegalStateException(Errors.format((short)159, this.getName()));
        }
        return this.isSparse ? new SparseFeature(this) : new DenseFeature(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.superTypes.hashCode() + 37 * this.properties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            DefaultFeatureType that = (DefaultFeatureType)obj;
            return this.isAbstract == that.isAbstract && this.superTypes.equals(that.superTypes) && this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }
}

