/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = 8866440357566645070L;
    private static final AtomicReference<FeatureFormat> INSTANCE = new AtomicReference();
    private final Locale displayLocale;

    public FeatureFormat() {
        super(Locale.getDefault(), TimeZone.getDefault());
        this.displayLocale = super.getLocale();
        this.columnSeparator = " \u2502 ";
    }

    public FeatureFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = " \u2502 ";
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    private void nextColumn(TableAppender table) {
        table.append(this.beforeFill);
        table.nextColumn(this.fillCharacter);
    }

    @Override
    public void format(Object object, Appendable toAppendTo) throws IOException {
        DefaultFeatureType featureType;
        AbstractFeature feature;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        if (object instanceof AbstractFeature) {
            feature = (AbstractFeature)object;
            featureType = feature.getType();
        } else if (object instanceof DefaultFeatureType) {
            featureType = (DefaultFeatureType)object;
            feature = null;
        } else {
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)129, object.getClass()));
        }
        boolean hasCharacteristics = false;
        for (AbstractIdentifiedType propertyType : featureType.getProperties(true)) {
            if (!(propertyType instanceof DefaultAttributeType) || ((DefaultAttributeType)propertyType).characteristics().isEmpty()) continue;
            hasCharacteristics = true;
            break;
        }
        toAppendTo.append(this.toString(featureType.getName())).append(this.getLineSeparator());
        Vocabulary resources = Vocabulary.getResources(this.displayLocale);
        TableAppender table = new TableAppender(toAppendTo, this.columnSeparator);
        table.setMultiLinesCells(true);
        table.nextLine('\u2500');
        int i = 0;
        block8: while (true) {
            int key;
            switch (i) {
                case 0: {
                    key = 37;
                    break;
                }
                case 1: {
                    this.nextColumn(table);
                    key = 56;
                    break;
                }
                case 2: {
                    this.nextColumn(table);
                    key = 76;
                    break;
                }
                case 3: {
                    this.nextColumn(table);
                    key = feature != null ? 60 : 71;
                    break;
                }
                case 4: {
                    if (!hasCharacteristics) break block8;
                    this.nextColumn(table);
                    key = 85;
                    break;
                }
                default: {
                    break block8;
                }
            }
            table.append(resources.getString((short)key));
            ++i;
        }
        table.nextLine();
        table.nextLine('\u2500');
        StringBuffer buffer = new StringBuffer();
        FieldPosition dummyFP = new FieldPosition(-1);
        for (AbstractIdentifiedType propertyType : featureType.getProperties(true)) {
            Object p;
            String valueType;
            Class<Object> valueClass;
            int maximumOccurs;
            int minimumOccurs;
            Object value;
            if (feature != null) {
                value = feature.getPropertyValue(propertyType.getName().toString());
                if (value == null && propertyType instanceof FieldType && ((FieldType)propertyType).getMinimumOccurs() == 0) {
                    continue;
                }
            } else {
                value = propertyType instanceof DefaultAttributeType ? ((DefaultAttributeType)propertyType).getDefaultValue() : null;
            }
            table.append(this.toString(propertyType.getName()));
            this.nextColumn(table);
            if (propertyType instanceof DefaultAttributeType) {
                DefaultAttributeType pt = (DefaultAttributeType)propertyType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueClass = pt.getValueClass();
                valueType = this.getFormat(Class.class).format(valueClass, buffer, dummyFP).toString();
                buffer.setLength(0);
            } else if (propertyType instanceof DefaultAssociationRole) {
                DefaultAssociationRole pt = (DefaultAssociationRole)propertyType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueType = this.toString(DefaultAssociationRole.getValueTypeName(pt));
                valueClass = AbstractFeature.class;
            } else if (propertyType instanceof AbstractOperation) {
                AbstractIdentifiedType resultType = ((AbstractOperation)propertyType).getResult();
                valueType = this.toString(resultType.getName());
                valueClass = null;
                minimumOccurs = -1;
                maximumOccurs = -1;
            } else {
                valueType = "";
                valueClass = null;
                minimumOccurs = -1;
                maximumOccurs = -1;
            }
            table.append(valueType);
            this.nextColumn(table);
            if (maximumOccurs >= 0) {
                Format format = this.getFormat(Integer.class);
                table.append('[').append(format.format(minimumOccurs, buffer, dummyFP)).append(" \u2026 ");
                buffer.setLength(0);
                if (maximumOccurs != Integer.MAX_VALUE) {
                    table.append(format.format(maximumOccurs, buffer, dummyFP));
                } else {
                    table.append('\u221e');
                }
                buffer.setLength(0);
                table.append(']');
            }
            this.nextColumn(table);
            if (value != null) {
                boolean isInstance = valueClass != null && valueClass.isInstance(value);
                Format format = isInstance ? this.getFormat(valueClass) : null;
                Iterator it = (!isInstance && value instanceof Collection ? (Collection)value : Collections.singleton(value)).iterator();
                String separator = "";
                while (it.hasNext()) {
                    value = it.next();
                    if (value == null) continue;
                    if (format != null) {
                        value = format.format(value, buffer, dummyFP);
                    } else if (value instanceof AbstractFeature && propertyType instanceof DefaultAssociationRole && (p = DefaultAssociationRole.getTitleProperty((DefaultAssociationRole)propertyType)) != null && (value = ((AbstractFeature)value).getPropertyValue((String)p)) == null) continue;
                    table.append(separator).append(this.formatValue(value));
                    buffer.setLength(0);
                    separator = ", ";
                }
            }
            if (hasCharacteristics) {
                this.nextColumn(table);
                if (propertyType instanceof DefaultAttributeType) {
                    String separator = "";
                    for (DefaultAttributeType<?> attribute : ((DefaultAttributeType)propertyType).characteristics().values()) {
                        table.append(separator).append(this.toString(attribute.getName()));
                        Object c = attribute.getDefaultValue();
                        if (feature != null && (p = feature.getProperty(propertyType.getName().toString())) instanceof AbstractAttribute) {
                            c = ((AbstractAttribute)p).characteristics().get(attribute.getName().toString());
                        }
                        if (c != null) {
                            table.append(" = ").append(this.formatValue(c));
                        }
                        separator = ", ";
                    }
                }
            }
            table.nextLine();
        }
        table.nextLine('\u2500');
        table.flush();
    }

    private String toString(GenericName name) {
        String s;
        if (name == null) {
            return "";
        }
        InternationalString i18n = name.toInternationalString();
        if (i18n != null && (s = i18n.toString(this.displayLocale)) != null) {
            return s;
        }
        return name.toString();
    }

    private String formatValue(Object value) {
        if (value instanceof InternationalString) {
            return ((InternationalString)value).toString(this.displayLocale);
        }
        if (value instanceof GenericName) {
            return this.toString((GenericName)value);
        }
        if (value instanceof AbstractIdentifiedType) {
            return this.toString(((AbstractIdentifiedType)value).getName());
        }
        if (value instanceof IdentifiedObject) {
            return IdentifiedObjects.getIdentifierOrName((IdentifiedObject)value);
        }
        return value.toString();
    }

    static String sharedFormat(Object object) {
        FeatureFormat f = INSTANCE.getAndSet(null);
        if (f == null) {
            f = new FeatureFormat();
        }
        String s = f.format(object);
        INSTANCE.set(f);
        return s;
    }

    @Override
    public Object parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)128, "parse"), 0);
    }
}

