/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.EnvelopeOperation;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.StringJoinOperation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class FeatureOperations
extends Static {
    static final WeakHashSet<AbstractIdentifiedType> POOL = new WeakHashSet<AbstractIdentifiedType>(AbstractIdentifiedType.class);

    private FeatureOperations() {
    }

    public static AbstractOperation link(Map<String, ?> identification, AbstractIdentifiedType referent) {
        ArgumentChecks.ensureNonNull("referent", referent);
        return POOL.unique(new LinkOperation(identification, referent));
    }

    public static AbstractOperation compound(Map<String, ?> identification, String delimiter, String prefix, String suffix, AbstractIdentifiedType ... singleAttributes) throws UnconvertibleObjectException {
        ArgumentChecks.ensureNonEmpty("delimiter", delimiter);
        if (delimiter.indexOf(92) >= 0) {
            throw new IllegalArgumentException(Errors.getResources(identification).getString((short)197, "delimiter", Character.valueOf('\\')));
        }
        ArgumentChecks.ensureNonNull("singleAttributes", singleAttributes);
        switch (singleAttributes.length) {
            case 0: {
                throw new IllegalArgumentException(Errors.getResources(identification).getString((short)20, "singleAttributes"));
            }
            case 1: {
                if (prefix != null && !prefix.isEmpty() || suffix != null && !suffix.isEmpty()) break;
                return FeatureOperations.link(identification, singleAttributes[0]);
            }
        }
        return POOL.unique(new StringJoinOperation(identification, delimiter, prefix, suffix, singleAttributes));
    }

    public static AbstractOperation envelope(Map<String, ?> identification, CoordinateReferenceSystem crs, AbstractIdentifiedType ... geometryAttributes) throws FactoryException {
        ArgumentChecks.ensureNonNull("geometryAttributes", geometryAttributes);
        return POOL.unique(new EnvelopeOperation(identification, crs, geometryAttributes));
    }
}

