/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class LinkOperation
extends AbstractOperation {
    private static final long serialVersionUID = 765096861589501215L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = LinkOperation.parameters("Link", 1, new ParameterDescriptor[0]);
    private final AbstractIdentifiedType result;
    final String referentName;

    static ParameterDescriptorGroup parameters(String name, int minimumOccurs, ParameterDescriptor<?> ... parameters) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        properties.put("authority", Citations.SIS);
        return new DefaultParameterDescriptorGroup(properties, minimumOccurs, 1, new GeneralParameterDescriptor[0]);
    }

    LinkOperation(Map<String, ?> identification, AbstractIdentifiedType referent) {
        super(identification);
        this.result = referent;
        this.referentName = referent.getName().toString();
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.result;
    }

    @Override
    public Set<String> getDependencies() {
        return Collections.singleton(this.referentName);
    }

    @Override
    public Object apply(AbstractFeature feature, ParameterValueGroup parameters) {
        ArgumentChecks.ensureNonNull("feature", feature);
        return feature.getProperty(this.referentName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.referentName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.referentName.equals(((LinkOperation)obj).referentName);
    }
}

