/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.internal.jdk7.Objects;

final class SingletonAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = -5247767277033831214L;
    private AbstractFeature value;

    public SingletonAssociation(DefaultAssociationRole role) {
        super(role);
        assert (SingletonAssociation.isSingleton(role.getMaximumOccurs()));
    }

    SingletonAssociation(DefaultAssociationRole role, AbstractFeature value) {
        super(role);
        assert (SingletonAssociation.isSingleton(role.getMaximumOccurs()));
        this.value = value;
        if (value != null) {
            this.ensureValid(role.getValueType(), value.getType());
        }
    }

    @Override
    public AbstractFeature getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractFeature value) throws IllegalArgumentException {
        if (value != null) {
            this.ensureValid(this.role.getValueType(), value.getType());
        }
        this.value = value;
    }

    public int hashCode() {
        return this.role.hashCode() + Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SingletonAssociation) {
            SingletonAssociation that = (SingletonAssociation)obj;
            return this.role.equals(that.role) && Objects.equals(this.value, that.value);
        }
        return false;
    }
}

