/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class StringJoinOperation
extends AbstractOperation {
    private static final long serialVersionUID = 2303047827010821381L;
    static final char ESCAPE = '\\';
    private static final ParameterDescriptorGroup EMPTY_PARAMS = LinkOperation.parameters("StringJoin", 1, new ParameterDescriptor[0]);
    private final String[] attributeNames;
    private final ObjectConverter<? super String, ?>[] converters;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<String> resultType;
    final String prefix;
    final String suffix;
    final String delimiter;

    StringJoinOperation(Map<String, ?> identification, String delimiter, String prefix, String suffix, AbstractIdentifiedType[] singleAttributes) throws UnconvertibleObjectException {
        super(identification);
        this.attributeNames = new String[singleAttributes.length];
        this.converters = new ObjectConverter[singleAttributes.length];
        for (int i = 0; i < singleAttributes.length; ++i) {
            AbstractIdentifiedType attributeType = singleAttributes[i];
            ArgumentChecks.ensureNonNullElement("singleAttributes", i, attributeType);
            GenericName name = attributeType.getName();
            if (attributeType instanceof AbstractOperation) {
                attributeType = ((AbstractOperation)attributeType).getResult();
            }
            if (!(attributeType instanceof DefaultAttributeType)) {
                throw new IllegalArgumentException(Errors.getResources(identification).getString((short)223, name, Classes.getLeafInterfaces(attributeType.getClass(), AbstractIdentifiedType.class)[0]));
            }
            if (((DefaultAttributeType)attributeType).getMaximumOccurs() > 1) {
                throw new IllegalArgumentException(Errors.getResources(identification).getString((short)158, name));
            }
            this.attributeNames[i] = name.toString();
            this.converters[i] = ObjectConverters.find(String.class, ((DefaultAttributeType)attributeType).getValueClass());
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), String.class, 1, 1, null, new DefaultAttributeType[0]));
        this.delimiter = delimiter;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    static <S> Object format(ObjectConverter<S, ?> converter, Object value) {
        return converter.apply(converter.getSourceClass().cast(value));
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        ArgumentChecks.ensureNonNull("feature", feature);
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + 37 * Objects.hash(this.delimiter, this.prefix, this.suffix);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            StringJoinOperation that = (StringJoinOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.converters, that.converters) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }
        return false;
    }

    private final class Result
    extends AbstractAttribute<String> {
        private static final long serialVersionUID = -8435975199763452547L;
        private final AbstractFeature feature;

        Result(AbstractFeature feature) {
            super(StringJoinOperation.this.resultType);
            this.feature = feature;
        }

        @Override
        public String getValue() throws UnconvertibleObjectException {
            StringBuilder sb = new StringBuilder();
            String sep = StringJoinOperation.this.prefix;
            String name = null;
            Object value = null;
            try {
                for (int i = 0; i < StringJoinOperation.this.attributeNames.length; ++i) {
                    name = StringJoinOperation.this.attributeNames[i];
                    value = this.feature.getPropertyValue(name);
                    value = StringJoinOperation.format(StringJoinOperation.this.converters[i].inverse(), value);
                    sb.append(sep);
                    sep = StringJoinOperation.this.delimiter;
                    if (value == null) continue;
                    int startAt = sb.length();
                    int j = sb.append(value).length();
                    while (--j >= startAt) {
                        if (sb.charAt(j) != '\\') continue;
                        sb.insert(j, '\\');
                    }
                    j = startAt;
                    while ((j = sb.indexOf(sep, j)) >= 0) {
                        sb.insert(j, '\\');
                        j += sep.length() + 1;
                    }
                }
            }
            catch (ClassCastException e) {
                if (value == null) {
                    throw e;
                }
                throw new UnconvertibleObjectException(Errors.format((short)40, name, value.getClass(), e));
            }
            return sb.append(StringJoinOperation.this.suffix).toString();
        }

        @Override
        public void setValue(String value) throws IllegalArgumentException {
            int lower;
            int endAt = value.length() - StringJoinOperation.this.suffix.length();
            boolean prefixMatches = value.startsWith(StringJoinOperation.this.prefix);
            if (!prefixMatches || !value.endsWith(StringJoinOperation.this.suffix)) {
                throw new IllegalArgumentException(Errors.format((short)225, this.getName(), prefixMatches ? 1 : 0, prefixMatches ? StringJoinOperation.this.suffix : StringJoinOperation.this.prefix, prefixMatches ? value.substring(Math.max(0, endAt)) : CharSequences.token(value, 0)));
            }
            Object[] values = new Object[StringJoinOperation.this.attributeNames.length];
            int upper = lower = StringJoinOperation.this.prefix.length();
            int count = 0;
            boolean done = false;
            do {
                if ((upper = value.indexOf(StringJoinOperation.this.delimiter, upper)) >= 0 && upper < endAt) {
                    int escape;
                    for (escape = upper; escape != 0 && value.charAt(escape - 1) == '\\'; --escape) {
                    }
                    if ((upper - escape & 1) != 0) {
                        upper += StringJoinOperation.this.delimiter.length() + 1;
                        continue;
                    }
                } else {
                    upper = endAt;
                    done = true;
                }
                String element = value.substring(lower, upper);
                int i = 0;
                while ((i = element.indexOf(92, i)) >= 0) {
                    if (i >= (element = new StringBuilder(element.length() - 1).append(element, 0, i).append(element, i + 1, element.length()).toString()).length()) continue;
                    if (element.charAt(i) == '\\') {
                        ++i;
                        continue;
                    }
                    assert (element.regionMatches(i, StringJoinOperation.this.delimiter, 0, StringJoinOperation.this.delimiter.length())) : element;
                    i += StringJoinOperation.this.delimiter.length();
                }
                if (!element.isEmpty() && count < values.length) {
                    try {
                        values[count] = StringJoinOperation.this.converters[count].apply(element);
                    }
                    catch (UnconvertibleObjectException e) {
                        throw new IllegalArgumentException(Errors.format((short)167, StringJoinOperation.this.attributeNames[count], element), e);
                    }
                }
                ++count;
                lower = upper += StringJoinOperation.this.delimiter.length();
            } while (!done);
            if (values.length != count) {
                throw new IllegalArgumentException(Errors.format((short)226, value, values.length, count));
            }
            for (int i = 0; i < values.length; ++i) {
                this.feature.setPropertyValue(StringJoinOperation.this.attributeNames[i], values[i]);
            }
        }
    }
}

