/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public abstract class AbstractDirectPosition
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    @Override
    public final DirectPosition getDirectPosition() {
        return this;
    }

    @Override
    public double[] getCoordinate() {
        double[] ordinates = new double[this.getDimension()];
        for (int i = 0; i < ordinates.length; ++i) {
            ordinates[i] = this.getOrdinate(i);
        }
        return ordinates;
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        int dimension = this.getDimension();
        if (position != null) {
            CoordinateReferenceSystem other;
            ArgumentChecks.ensureDimensionMatches("position", dimension, position);
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            if (crs != null && (other = position.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata(crs, other)) {
                throw new MismatchedReferenceSystemException(Errors.format((short)57));
            }
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, position.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    public boolean normalize() {
        boolean changed = false;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            int dimension = this.getDimension();
            CoordinateSystem cs = crs.getCoordinateSystem();
            for (int i = 0; i < dimension; ++i) {
                double ordinate = this.getOrdinate(i);
                CoordinateSystemAxis axis = cs.getAxis(i);
                double minimum = axis.getMinimumValue();
                double maximum = axis.getMaximumValue();
                RangeMeaning rm = axis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals(rm)) {
                    if (ordinate < minimum) {
                        ordinate = minimum;
                    } else {
                        if (!(ordinate > maximum)) continue;
                        ordinate = maximum;
                    }
                } else if (RangeMeaning.WRAPAROUND.equals(rm)) {
                    double csSpan = maximum - minimum;
                    double shift = Math.floor((ordinate - minimum) / csSpan) * csSpan;
                    if (shift == 0.0) continue;
                    ordinate -= shift;
                }
                this.setOrdinate(i, ordinate);
                changed = true;
            }
        }
        return changed;
    }

    static boolean isSimplePrecision(double ... values) {
        for (double value : values) {
            if (Double.doubleToLongBits(value) == Double.doubleToLongBits((float)value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return AbstractDirectPosition.toString(this, false);
    }

    static String toString(DirectPosition position, boolean isSimplePrecision) {
        StringBuilder buffer = new StringBuilder(32).append("POINT");
        int dimension = position.getDimension();
        if (dimension == 0) {
            buffer.append("()");
        } else {
            int separator = 40;
            for (int i = 0; i < dimension; ++i) {
                buffer.append((char)separator);
                double ordinate = position.getOrdinate(i);
                if (isSimplePrecision) {
                    buffer.append((float)ordinate);
                } else {
                    buffer.append(ordinate);
                }
                StringBuilders.trimFractionalPart(buffer);
                separator = 32;
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    static double[] parse(CharSequence wkt) throws NumberFormatException, IllegalArgumentException {
        int c;
        int length = CharSequences.skipTrailingWhitespaces(wkt, 0, wkt.length());
        int i = CharSequences.skipLeadingWhitespaces(wkt, 0, length);
        while (true) {
            if (i >= length) {
                return null;
            }
            c = Character.codePointAt(wkt, i);
            if (Character.isUnicodeIdentifierStart(c)) {
                do {
                    if ((i += Character.charCount(c)) < length) continue;
                    return null;
                } while (Character.isUnicodeIdentifierPart(c = Character.codePointAt(wkt, i)));
            }
            if (!Character.isSpaceChar(c)) break;
            i += Character.charCount(c);
        }
        if (c == 40 || c == 91) {
            i += Character.charCount(c);
            char close = c == 40 ? (char)')' : ']';
            int pos = CharSequences.lastIndexOf(wkt, close, i = CharSequences.skipLeadingWhitespaces(wkt, i, length), length);
            if (pos != --length) {
                Object[] args;
                short key;
                if (pos < 0) {
                    key = 79;
                    args = new Object[]{wkt, Character.valueOf(close)};
                } else {
                    key = 125;
                    args = new Object[]{"POINT", wkt, CharSequences.trimWhitespaces(wkt, pos + 1, length + 1)};
                }
                throw new IllegalArgumentException(Errors.format(key, args));
            }
            c = Character.codePointAt(wkt, i);
        }
        double[] ordinates = new double[2];
        int dimension = 0;
        block2: while (i < length) {
            int start = i;
            do {
                if ((i += Character.charCount(c)) < length) continue;
                c = 0;
                break;
            } while (!Character.isSpaceChar(c = Character.codePointAt(wkt, i)));
            double value = Double.parseDouble(wkt.subSequence(start, i).toString());
            if (dimension == ordinates.length) {
                ordinates = Arrays.copyOf(ordinates, dimension * 2);
            }
            ordinates[dimension++] = value;
            while (Character.isSpaceChar(c)) {
                if ((i += Character.charCount(c)) >= length) break block2;
                c = Character.codePointAt(wkt, i);
            }
        }
        return ArraysExt.resize(ordinates, dimension);
    }

    @Override
    public int hashCode() {
        int dimension = this.getDimension();
        int code = 1;
        for (int i = 0; i < dimension; ++i) {
            code = code * 31 + Numerics.hashCode(Double.doubleToLongBits(this.getOrdinate(i)));
        }
        return code + Objects.hashCode(this.getCoordinateReferenceSystem());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DirectPosition) {
            DirectPosition that = (DirectPosition)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Numerics.equals(this.getOrdinate(i), that.getOrdinate(i))) continue;
                    return false;
                }
                if (Objects.equals(this.getCoordinateReferenceSystem(), that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

