/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

class ArrayEnvelope
extends AbstractEnvelope
implements Serializable {
    private static final long serialVersionUID = 1657970968782634545L;
    final double[] ordinates;
    CoordinateReferenceSystem crs;

    ArrayEnvelope(double[] ordinates) {
        this.ordinates = ordinates;
    }

    public ArrayEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        this.crs = ArrayEnvelope.getCommonCRS(lowerCorner, upperCorner);
        int dimension = lowerCorner.getDimension();
        ArgumentChecks.ensureDimensionMatches("crs", dimension, this.crs);
        ArrayEnvelope.ensureSameDimension(dimension, upperCorner.getDimension());
        this.ordinates = new double[dimension * 2];
        for (int i = 0; i < dimension; ++i) {
            this.ordinates[i] = lowerCorner.getOrdinate(i);
            this.ordinates[i + dimension] = upperCorner.getOrdinate(i);
        }
        ArrayEnvelope.verifyRanges(this.crs, this.ordinates);
    }

    public ArrayEnvelope(double[] lowerCorner, double[] upperCorner) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("lowerCorner", lowerCorner);
        ArgumentChecks.ensureNonNull("upperCorner", upperCorner);
        ArrayEnvelope.ensureSameDimension(lowerCorner.length, upperCorner.length);
        this.ordinates = Arrays.copyOf(lowerCorner, lowerCorner.length + upperCorner.length);
        System.arraycopy(upperCorner, 0, this.ordinates, lowerCorner.length, upperCorner.length);
    }

    public ArrayEnvelope(int dimension) {
        this.ordinates = new double[dimension * 2];
    }

    public ArrayEnvelope(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureNonNull("crs", crs);
        this.ordinates = new double[crs.getCoordinateSystem().getDimension() * 2];
        this.crs = crs;
    }

    public ArrayEnvelope(Envelope envelope) {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        int dimension = envelope.getDimension();
        this.ordinates = new double[dimension * 2];
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        for (int i = 0; i < dimension; ++i) {
            this.ordinates[i] = lowerCorner.getOrdinate(i);
            this.ordinates[i + dimension] = upperCorner.getOrdinate(i);
        }
        ArrayEnvelope.verifyRanges(this.crs, this.ordinates);
    }

    public ArrayEnvelope(GeographicBoundingBox box) {
        ArgumentChecks.ensureNonNull("box", box);
        this.ordinates = new double[]{box.getWestBoundLongitude(), box.getSouthBoundLatitude(), box.getEastBoundLongitude(), box.getNorthBoundLatitude()};
        if (Boolean.FALSE.equals(box.getInclusion())) {
            ArraysExt.swap(this.ordinates, 0, this.ordinates.length >>> 1);
            if (!Formulas.isPoleToPole(this.ordinates[1], this.ordinates[3])) {
                ArraysExt.swap(this.ordinates, 1, (this.ordinates.length >>> 1) + 1);
            }
        }
        this.crs = CommonCRS.defaultGeographic();
        ArrayEnvelope.verifyRanges(this.crs, this.ordinates);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayEnvelope(CharSequence wkt) throws IllegalArgumentException {
        super();
        ArgumentChecks.ensureNonNull("wkt", wkt);
        levelParenth = 0;
        levelBracket = 0;
        dimLimit = 4;
        maxDimension = 0;
        length = CharSequences.skipTrailingWhitespaces(wkt, 0, wkt.length());
        minimum = new double[dimLimit];
        maximum = new double[dimLimit];
        dimension = 0;
        block12: for (i = CharSequences.skipLeadingWhitespaces(wkt, 0, length); i < length; i += Character.charCount(c)) {
            c = Character.codePointAt(wkt, i);
            if (!Character.isUnicodeIdentifierStart(c)) ** GOTO lbl17
            while ((i += Character.charCount(c)) < length) {
                c = Character.codePointAt(wkt, i);
                if (Character.isUnicodeIdentifierPart(c)) continue;
lbl17:
                // 2 sources

                if (Character.isSpaceChar(c)) continue block12;
                switch (c) {
                    case 44: {
                        dimension = 0;
                        continue block12;
                    }
                    case 40: {
                        ++levelParenth;
                        dimension = 0;
                        continue block12;
                    }
                    case 91: {
                        ++levelBracket;
                        dimension = 0;
                        continue block12;
                    }
                    case 41: {
                        if (--levelParenth < 0) {
                            ArrayEnvelope.fail(wkt, '(');
                        }
                        dimension = 0;
                        continue block12;
                    }
                    case 93: {
                        if (--levelBracket < 0) {
                            ArrayEnvelope.fail(wkt, '[');
                        }
                        dimension = 0;
                        continue block12;
                    }
                    default: {
                        start = i;
                        flush = false;
                        block14: while ((i += Character.charCount(c)) < length && !Character.isSpaceChar(c = (int)wkt.charAt(i))) {
                            switch (c) {
                                case 44: {
                                    flush = true;
                                    break block14;
                                }
                                case 41: {
                                    if (--levelParenth < 0) {
                                        ArrayEnvelope.fail(wkt, '(');
                                    }
                                    flush = true;
                                    break block14;
                                }
                                case 93: {
                                    if (--levelBracket < 0) {
                                        ArrayEnvelope.fail(wkt, '[');
                                    }
                                    flush = true;
                                    break block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                        }
                        value = Double.parseDouble(wkt.subSequence(start, i).toString());
                        if (dimension == maxDimension) {
                            if (dimension == dimLimit) {
                                minimum = Arrays.copyOf(minimum, dimLimit *= 2);
                                maximum = Arrays.copyOf(maximum, dimLimit);
                            }
                            minimum[dimension] = maximum[dimension] = value;
                            maxDimension = ++dimension;
                        } else {
                            if (value < minimum[dimension]) {
                                minimum[dimension] = value;
                            }
                            if (value > maximum[dimension]) {
                                maximum[dimension] = value;
                            }
                            ++dimension;
                        }
                        if (!flush) continue block12;
                        dimension = 0;
                    }
                }
                continue block12;
            }
            break block12;
        }
        if (levelParenth != 0) {
            ArrayEnvelope.fail(wkt, ')');
        }
        if (levelBracket != 0) {
            ArrayEnvelope.fail(wkt, ']');
        }
        this.ordinates = ArraysExt.resize(minimum, maxDimension << 1);
        System.arraycopy(maximum, 0, this.ordinates, maxDimension, maxDimension);
    }

    private static void fail(CharSequence wkt, char missing) {
        throw new IllegalArgumentException(Errors.format((short)79, wkt, Character.valueOf(missing)));
    }

    static void ensureSameDimension(int dim1, int dim2) throws MismatchedDimensionException {
        if (dim1 != dim2) {
            throw new MismatchedDimensionException(Errors.format((short)58, dim1, dim2));
        }
    }

    static void verifyRanges(CoordinateReferenceSystem crs, double[] ordinates) {
        if (crs != null) {
            int dimension = ordinates.length >>> 1;
            for (int i = 0; i < dimension; ++i) {
                double lower = ordinates[i];
                double upper = ordinates[i + dimension];
                if (!(lower > upper) || ArrayEnvelope.isWrapAround(crs, i)) continue;
                throw new IllegalArgumentException(ArrayEnvelope.illegalRange(crs, i, lower, upper));
            }
        }
    }

    static String illegalRange(CoordinateReferenceSystem crs, int dimension, double lower, double upper) {
        Object name = IdentifiedObjects.getName(ArrayEnvelope.getAxis(crs, dimension), null);
        if (name == null) {
            name = dimension;
        }
        return Errors.format((short)39, lower, upper, name);
    }

    int beginIndex() {
        return 0;
    }

    int endIndex() {
        return this.ordinates.length >>> 1;
    }

    @Override
    public int getDimension() {
        return this.ordinates.length >>> 1;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    @Override
    public double getLower(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.ordinates.length >>> 1, dimension);
        return this.ordinates[dimension];
    }

    @Override
    public double getUpper(int dimension) throws IndexOutOfBoundsException {
        int d = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(d, dimension);
        return this.ordinates[dimension + d];
    }

    @Override
    public double getMinimum(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), dimension);
        int i = dimension + this.beginIndex();
        double lower = this.ordinates[i];
        if (MathFunctions.isNegative(this.ordinates[i + (this.ordinates.length >>> 1)] - lower)) {
            CoordinateSystemAxis axis = ArrayEnvelope.getAxis(this.crs, dimension);
            lower = axis != null ? axis.getMinimumValue() : Double.NEGATIVE_INFINITY;
        }
        return lower;
    }

    @Override
    public double getMaximum(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), dimension);
        int i = dimension + this.beginIndex();
        double upper = this.ordinates[i + (this.ordinates.length >>> 1)];
        if (MathFunctions.isNegative(upper - this.ordinates[i])) {
            CoordinateSystemAxis axis = ArrayEnvelope.getAxis(this.crs, dimension);
            upper = axis != null ? axis.getMaximumValue() : Double.POSITIVE_INFINITY;
        }
        return upper;
    }

    @Override
    public double getMedian(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), dimension);
        int i = dimension + this.beginIndex();
        double minimum = this.ordinates[i];
        double maximum = this.ordinates[i + (this.ordinates.length >>> 1)];
        double median = 0.5 * (minimum + maximum);
        if (MathFunctions.isNegative(maximum - minimum)) {
            median = ArrayEnvelope.fixMedian(ArrayEnvelope.getAxis(this.crs, dimension), median);
        }
        return median;
    }

    @Override
    public double getSpan(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), dimension);
        int i = dimension + this.beginIndex();
        double span = this.ordinates[i + (this.ordinates.length >>> 1)] - this.ordinates[i];
        if (MathFunctions.isNegative(span)) {
            span = ArrayEnvelope.fixSpan(ArrayEnvelope.getAxis(this.crs, dimension), span);
        }
        return span;
    }

    @Override
    public boolean isEmpty() {
        int endIndex;
        int beginIndex = this.beginIndex();
        if (beginIndex == (endIndex = this.endIndex())) {
            return true;
        }
        int d = this.ordinates.length >>> 1;
        for (int i = beginIndex; i < endIndex; ++i) {
            double span = this.ordinates[i + d] - this.ordinates[i];
            if (span > 0.0 || MathFunctions.isNegative(span) && ArrayEnvelope.isWrapAround(this.crs, i - beginIndex)) continue;
            return true;
        }
        assert (!this.isAllNaN()) : this;
        return false;
    }

    @Override
    public boolean isAllNaN() {
        for (int i = 0; i < this.ordinates.length; ++i) {
            if (Double.isNaN(this.ordinates[i])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == this.hashCodeByAPI());
        return code;
    }

    final int hashCodeByAPI() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ArrayEnvelope that = (ArrayEnvelope)object;
            return Arrays.equals(this.ordinates, that.ordinates) && Objects.equals(this.crs, that.crs);
        }
        return false;
    }

    final boolean equalsByAPI(Object object) {
        return super.equals(object);
    }

    @Override
    public String toString() {
        return ArrayEnvelope.toString(this, AbstractDirectPosition.isSimplePrecision(this.ordinates));
    }
}

