/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9196647508968517838L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", 1, crs);
        this.crs = crs;
    }

    public DirectPosition1D(double ordinate) {
        this.ordinate = ordinate;
    }

    public DirectPosition1D(CharSequence wkt) throws IllegalArgumentException {
        double[] ordinates = DirectPosition1D.parse(wkt);
        if (ordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)124, "POINT", wkt));
        }
        ArgumentChecks.ensureDimensionMatches("wkt", 1, ordinates);
        this.ordinate = ordinates[0];
    }

    @Override
    public final int getDimension() {
        return 1;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches("crs", 1, crs);
        this.crs = crs;
    }

    @Override
    public final double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)49, dimension));
    }

    @Override
    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(Errors.format((short)49, dimension));
        }
        this.ordinate = value;
    }

    @Override
    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches("position", 1, position);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.ordinate = position.getOrdinate(0);
    }

    @Override
    public String toString() {
        return DirectPosition1D.toString(this, this.ordinate == (double)((float)this.ordinate));
    }

    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int code = 31 + Numerics.hashCode(Double.doubleToLongBits(this.ordinate)) + Objects.hashCode(this.crs);
        assert (code == super.hashCode());
        return code;
    }
}

