/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5524426558018300122L;
    private static volatile Field ordinatesField;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralDirectPosition(int dimension) throws NegativeArraySizeException {
        this.ordinates = new double[dimension];
    }

    public GeneralDirectPosition(double ... ordinates) {
        this.ordinates = ordinates;
    }

    public GeneralDirectPosition(DirectPosition point) {
        this.ordinates = point.getCoordinate();
        this.crs = point.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches("crs", this.ordinates.length, this.crs);
    }

    public GeneralDirectPosition(CharSequence wkt) throws IllegalArgumentException {
        this.ordinates = GeneralDirectPosition.parse(wkt);
        if (this.ordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)124, "POINT", wkt));
        }
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
        this.crs = crs;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    public void setCoordinate(double ... ordinates) throws MismatchedDimensionException {
        if (ordinates == null) {
            Arrays.fill(this.ordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("ordinates", this.ordinates.length, ordinates);
            System.arraycopy(ordinates, 0, this.ordinates, 0, ordinates.length);
        }
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension];
    }

    @Override
    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.ordinates[dimension] = value;
    }

    @Override
    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        if (position == null) {
            Arrays.fill(this.ordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("position", this.ordinates.length, position);
            this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
            for (int i = 0; i < this.ordinates.length; ++i) {
                this.ordinates[i] = position.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, GeneralDirectPosition.isSimplePrecision(this.ordinates));
    }

    static Field getOrdinatesField(Class<?> type) throws NoSuchFieldException {
        final Field field = type.getDeclaredField("ordinates");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                field.setAccessible(true);
                return null;
            }
        });
        return field;
    }

    public GeneralDirectPosition clone() {
        try {
            Field field = ordinatesField;
            if (field == null) {
                ordinatesField = field = GeneralDirectPosition.getOrdinatesField(GeneralDirectPosition.class);
            }
            GeneralDirectPosition e = (GeneralDirectPosition)super.clone();
            field.set(e, this.ordinates.clone());
            return e;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates) + Objects.hashCode(this.getCoordinateReferenceSystem());
        assert (code == super.hashCode());
        return code;
    }
}

