/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.geometry.SubEnvelope;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public class GeneralEnvelope
extends ArrayEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3796799507279068254L;
    private static volatile Field ordinatesField;

    GeneralEnvelope(double[] ordinates) {
        super(ordinates);
    }

    public GeneralEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        super(lowerCorner, upperCorner);
    }

    public GeneralEnvelope(double[] lowerCorner, double[] upperCorner) throws MismatchedDimensionException {
        super(lowerCorner, upperCorner);
    }

    public GeneralEnvelope(int dimension) {
        super(dimension);
    }

    public GeneralEnvelope(CoordinateReferenceSystem crs) {
        super(crs);
    }

    public GeneralEnvelope(Envelope envelope) {
        super(envelope);
    }

    public GeneralEnvelope(GeographicBoundingBox box) {
        super(box);
    }

    public GeneralEnvelope(CharSequence wkt) throws IllegalArgumentException {
        super(wkt);
    }

    public static GeneralEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof GeneralEnvelope) {
            return (GeneralEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), crs);
        if (crs != null) {
            int beginIndex = this.beginIndex();
            int endIndex = this.endIndex();
            int d = this.ordinates.length >>> 1;
            for (int i = beginIndex; i < endIndex; ++i) {
                int j;
                double lower = this.ordinates[i];
                double upper = this.ordinates[i + d];
                if (!(lower > upper) || GeneralEnvelope.isWrapAround(crs, j = i - beginIndex)) continue;
                throw new IllegalStateException(GeneralEnvelope.illegalRange(crs, j, lower, upper));
            }
        }
        this.crs = crs;
    }

    @Override
    public void setRange(int dimension, double lower, double upper) throws IndexOutOfBoundsException {
        int d = this.ordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(d, dimension);
        if (lower > upper && this.crs != null && !GeneralEnvelope.isWrapAround(this.crs, dimension)) {
            throw new IllegalArgumentException(GeneralEnvelope.illegalRange(this.crs, dimension, lower, upper));
        }
        this.ordinates[dimension + d] = upper;
        this.ordinates[dimension] = lower;
    }

    public void setEnvelope(double ... corners) {
        GeneralEnvelope.verifyArrayLength(this.ordinates.length >>> 1, corners);
        GeneralEnvelope.verifyRanges(this.crs, corners);
        System.arraycopy(corners, 0, this.ordinates, 0, this.ordinates.length);
    }

    static void verifyArrayLength(int dimension, double[] corners) {
        if ((corners.length & 1) != 0) {
            throw new IllegalArgumentException(Errors.format((short)98, corners.length));
        }
        int d = corners.length >>> 1;
        if (d != dimension) {
            throw new MismatchedDimensionException(Errors.format((short)59, "ordinates", dimension, d));
        }
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches("envelope", dimension, envelope);
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        int d = this.ordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            this.ordinates[iLower] = lower.getOrdinate(i);
            this.ordinates[iUpper] = upper.getOrdinate(i);
        }
        CoordinateReferenceSystem envelopeCRS = envelope.getCoordinateReferenceSystem();
        if (envelopeCRS != null) {
            this.crs = envelopeCRS;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (envelope.getClass() != this.getClass() || this.equals(envelope)) : envelope;
        }
    }

    public void setToInfinite() {
        int beginIndex = this.beginIndex();
        int endIndex = this.endIndex();
        int d = this.ordinates.length >>> 1;
        Arrays.fill(this.ordinates, beginIndex, endIndex, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, beginIndex + d, endIndex + d, Double.POSITIVE_INFINITY);
    }

    public void setToNaN() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    public void translate(double ... vector) {
        ArgumentChecks.ensureNonNull("vector", vector);
        int beginIndex = this.beginIndex();
        ArgumentChecks.ensureDimensionMatches("vector", this.endIndex() - beginIndex, vector);
        int upperIndex = beginIndex + (this.ordinates.length >>> 1);
        for (int i = 0; i < vector.length; ++i) {
            double t = vector[i];
            int n = beginIndex + i;
            this.ordinates[n] = this.ordinates[n] + t;
            int n2 = upperIndex + i;
            this.ordinates[n2] = this.ordinates[n2] + t;
        }
    }

    final void addSimple(double[] array, int offset) {
        int d = this.ordinates.length >>> 1;
        for (int i = 0; i < d; ++i) {
            double value = array[offset + i];
            if (value < this.ordinates[i]) {
                this.ordinates[i] = value;
            }
            if (!(value > this.ordinates[i + d])) continue;
            this.ordinates[i + d] = value;
        }
    }

    public void add(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("position", position);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches("position", dimension, position);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem(), true)) : position;
        int d = this.ordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double value = position.getOrdinate(i);
            double max = this.ordinates[iUpper];
            double min = this.ordinates[iLower];
            if (!MathFunctions.isNegative(max - min)) {
                if (value < min) {
                    this.ordinates[iLower] = value;
                }
                if (!(value > max)) continue;
                this.ordinates[iUpper] = value;
                continue;
            }
            this.addToClosest(iLower, value, max, min);
        }
        assert (this.contains(position) || this.isEmpty() || GeneralEnvelope.hasNaN(position)) : position;
    }

    private void addToClosest(int i, double value, double left, double right) {
        if ((left = value - left) > 0.0 && (right -= value) > 0.0) {
            if (right > left) {
                i += this.ordinates.length >>> 1;
            }
            this.ordinates[i] = value;
        }
    }

    public void add(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches("envelope", dimension, envelope);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        int d = this.ordinates.length >>> 1;
        for (int i = 0; i < dimension; ++i) {
            double right;
            double left;
            boolean sp1;
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double min0 = this.ordinates[iLower];
            double max0 = this.ordinates[iUpper];
            double min1 = lower.getOrdinate(i);
            double max1 = upper.getOrdinate(i);
            boolean sp0 = MathFunctions.isNegative(max0 - min0);
            if (sp0 == (sp1 = MathFunctions.isNegative(max1 - min1))) {
                if (min1 < min0) {
                    this.ordinates[iLower] = min1;
                }
                if (max1 > max0) {
                    this.ordinates[iUpper] = max1;
                }
                if (!sp0 || GeneralEnvelope.isNegativeUnsafe(this.ordinates[iUpper] - this.ordinates[iLower])) {
                    continue;
                }
            } else if (sp0) {
                if (max1 <= max0 || min1 >= min0) continue;
                left = min1 - max0;
                right = min0 - max1;
                if (left > 0.0 || right > 0.0) {
                    if (left > right) {
                        this.ordinates[iLower] = min1;
                    }
                    if (!(right > left)) continue;
                    this.ordinates[iUpper] = max1;
                    continue;
                }
            } else {
                if (max0 <= max1 || min0 >= min1) {
                    this.ordinates[iLower] = min1;
                    this.ordinates[iUpper] = max1;
                    continue;
                }
                left = min0 - max1;
                right = min1 - max0;
                if (left > 0.0 || right > 0.0) {
                    if (left > right) {
                        this.ordinates[iUpper] = max1;
                    }
                    if (!(right > left)) continue;
                    this.ordinates[iLower] = min1;
                    continue;
                }
            }
            if (sp0) {
                this.ordinates[iLower] = 0.0;
                this.ordinates[iUpper] = -0.0;
                continue;
            }
            this.ordinates[iLower] = Double.NEGATIVE_INFINITY;
            this.ordinates[iUpper] = Double.POSITIVE_INFINITY;
        }
        assert (this.contains(envelope) || this.isEmpty() || GeneralEnvelope.hasNaN(envelope)) : this;
    }

    public void intersect(Envelope envelope) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        ArgumentChecks.ensureDimensionMatches("envelope", dimension, envelope);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition lower = envelope.getLowerCorner();
        DirectPosition upper = envelope.getUpperCorner();
        int d = this.ordinates.length >>> 1;
        block5: for (int i = beginIndex; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double min0 = this.ordinates[iLower];
            double max0 = this.ordinates[iUpper];
            double min1 = lower.getOrdinate(i);
            double span0 = max0 - min0;
            double max1 = upper.getOrdinate(i);
            double span1 = max1 - min1;
            if (MathFunctions.isSameSign(span0, span1)) {
                if ((min1 > max0 || max1 < min0) && !GeneralEnvelope.isNegativeUnsafe(span0)) {
                    this.ordinates[iUpper] = Double.NaN;
                    this.ordinates[iLower] = Double.NaN;
                    continue;
                }
            } else {
                int intersect = 0;
                if (!Double.isNaN(span0) && !Double.isNaN(span1)) {
                    if (GeneralEnvelope.isNegativeUnsafe(span0)) {
                        if (min1 <= max0) {
                            intersect = 1;
                            this.ordinates[iLower] = min1;
                        }
                        if (max1 >= min0) {
                            intersect |= 2;
                            this.ordinates[iUpper] = max1;
                        }
                    } else {
                        if (min0 <= max1) {
                            intersect = 1;
                        }
                        if (max0 >= min1) {
                            intersect |= 2;
                        }
                    }
                }
                switch (intersect) {
                    default: {
                        throw new AssertionError(intersect);
                    }
                    case 1: {
                        if (!(max1 < max0)) continue block5;
                        this.ordinates[iUpper] = max1;
                        break;
                    }
                    case 2: {
                        if (!(min1 > min0)) continue block5;
                        this.ordinates[iLower] = min1;
                        break;
                    }
                    case 0: 
                    case 3: {
                        double max;
                        double min;
                        double csSpan = GeneralEnvelope.getSpan(GeneralEnvelope.getAxis(this.crs, i));
                        if (span1 >= csSpan) {
                            min = min0;
                            max = max0;
                        } else if (span0 >= csSpan) {
                            min = min1;
                            max = max1;
                        } else {
                            min = Double.NaN;
                            max = Double.NaN;
                        }
                        this.ordinates[iLower] = min;
                        this.ordinates[iUpper] = max;
                        break;
                    }
                }
                continue;
            }
            if (min1 > min0) {
                this.ordinates[iLower] = min1;
            }
            if (!(max1 < max0)) continue;
            this.ordinates[iUpper] = max1;
        }
        assert (this.isEmpty() || AbstractEnvelope.castOrCopy(envelope).contains(this)) : this;
    }

    public boolean normalize() {
        boolean changed = false;
        if (this.crs != null) {
            int d = this.ordinates.length >>> 1;
            int beginIndex = this.beginIndex();
            int dimension = this.endIndex() - beginIndex;
            CoordinateSystem cs = this.crs.getCoordinateSystem();
            for (int i = 0; i < dimension; ++i) {
                double csSpan;
                int iLower = beginIndex + i;
                int iUpper = iLower + d;
                CoordinateSystemAxis axis = cs.getAxis(i);
                double minimum = axis.getMinimumValue();
                double maximum = axis.getMaximumValue();
                RangeMeaning rm = axis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals(rm)) {
                    if (this.ordinates[iLower] < minimum) {
                        this.ordinates[iLower] = minimum;
                        changed = true;
                    }
                    if (!(this.ordinates[iUpper] > maximum)) continue;
                    this.ordinates[iUpper] = maximum;
                    changed = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals(rm) || !((csSpan = maximum - minimum) > 0.0) || !(csSpan < Double.POSITIVE_INFINITY)) continue;
                double o2 = this.ordinates[iUpper];
                double o1 = this.ordinates[iLower];
                if (Math.abs(o2 - o1) >= csSpan) {
                    if (o1 == minimum && o2 == maximum) continue;
                    if (o1 % csSpan == 0.0 && o2 % csSpan == 0.0) {
                        this.ordinates[iLower] = 0.0;
                        this.ordinates[iUpper] = -0.0;
                    } else {
                        this.ordinates[iLower] = minimum;
                        this.ordinates[iUpper] = maximum;
                    }
                    changed = true;
                    continue;
                }
                o1 = Math.floor((o1 - minimum) / csSpan) * csSpan;
                o2 = Math.floor((o2 - minimum) / csSpan) * csSpan;
                if (o1 != 0.0) {
                    int n = iLower;
                    this.ordinates[n] = this.ordinates[n] - o1;
                    changed = true;
                }
                if (o2 == 0.0) continue;
                int n = iUpper;
                this.ordinates[n] = this.ordinates[n] - o2;
                changed = true;
            }
        }
        return changed;
    }

    public boolean simplify() throws IllegalStateException {
        boolean changed = false;
        int d = this.ordinates.length >>> 1;
        int beginIndex = this.beginIndex();
        int dimension = this.endIndex() - beginIndex;
        for (int i = 0; i < dimension; ++i) {
            int iLower = beginIndex + i;
            int iUpper = iLower + d;
            double upper = this.ordinates[iUpper];
            double lower = this.ordinates[iLower];
            if (!MathFunctions.isNegative(upper - lower)) continue;
            CoordinateSystemAxis axis = GeneralEnvelope.getAxis(this.crs, i);
            if (axis != null && RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning())) {
                this.ordinates[iLower] = axis.getMinimumValue();
                this.ordinates[iUpper] = axis.getMaximumValue();
                changed = true;
                continue;
            }
            throw new IllegalStateException(Errors.format((short)39, lower, upper, axis != null ? axis.getName() : Integer.valueOf(i)));
        }
        return changed;
    }

    public GeneralEnvelope subEnvelope(int beginIndex, int endIndex) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange(this.ordinates.length >>> 1, beginIndex, endIndex);
        return new SubEnvelope(this.ordinates, beginIndex, endIndex);
    }

    public GeneralEnvelope clone() {
        try {
            Field field = ordinatesField;
            if (field == null) {
                ordinatesField = field = GeneralDirectPosition.getOrdinatesField(ArrayEnvelope.class);
            }
            GeneralEnvelope e = (GeneralEnvelope)super.clone();
            field.set(e, this.ordinates.clone());
            return e;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

