/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.util.ArgumentChecks;

final class SubEnvelope
extends GeneralEnvelope {
    private static final long serialVersionUID = 7241242611077979466L;
    private final int beginIndex;
    private final int endIndex;

    SubEnvelope(double[] ordinates, int beginIndex, int endIndex) {
        super(ordinates);
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    @Override
    final int beginIndex() {
        return this.beginIndex;
    }

    @Override
    final int endIndex() {
        return this.endIndex;
    }

    @Override
    public int getDimension() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public double getLower(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, dimension);
        return this.ordinates[dimension + this.beginIndex];
    }

    @Override
    public double getUpper(int dimension) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, dimension);
        return this.ordinates[dimension + this.beginIndex + (this.ordinates.length >>> 1)];
    }

    @Override
    public void setRange(int dimension, double lower, double upper) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, dimension);
        if (lower > upper && this.crs != null && !SubEnvelope.isWrapAround(this.crs, dimension)) {
            throw new IllegalArgumentException(SubEnvelope.illegalRange(this.crs, dimension, lower, upper));
        }
        this.ordinates[(dimension += this.beginIndex) + (this.ordinates.length >>> 1)] = upper;
        this.ordinates[dimension] = lower;
    }

    @Override
    public void setEnvelope(double ... corners) {
        int dimension = this.getDimension();
        SubEnvelope.verifyArrayLength(dimension, corners);
        SubEnvelope.verifyRanges(this.crs, corners);
        int d = this.ordinates.length >>> 1;
        System.arraycopy(corners, 0, this.ordinates, this.beginIndex, dimension);
        System.arraycopy(corners, dimension, this.ordinates, this.beginIndex + d, dimension);
    }

    @Override
    public boolean isAllNaN() {
        int d = this.ordinates.length >>> 1;
        for (int i = this.beginIndex; i < this.endIndex; ++i) {
            if (Double.isNaN(this.ordinates[i]) && Double.isNaN(this.ordinates[i + d])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public void setToNaN() {
        int d = this.ordinates.length >>> 1;
        Arrays.fill(this.ordinates, this.beginIndex, this.endIndex, Double.NaN);
        Arrays.fill(this.ordinates, this.beginIndex + d, this.endIndex + d, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    @Override
    public int hashCode() {
        return this.hashCodeByAPI();
    }

    @Override
    public boolean equals(Object object) {
        return this.equalsByAPI(object);
    }

    @Override
    public GeneralEnvelope subEnvelope(int b, int e) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange(this.endIndex - this.beginIndex, b, e);
        return new SubEnvelope(this.ordinates, b + this.beginIndex, e + this.beginIndex);
    }

    @Override
    public GeneralEnvelope clone() {
        int d = this.ordinates.length >>> 1;
        int dimension = this.endIndex - this.beginIndex;
        GeneralEnvelope copy = new GeneralEnvelope(this.endIndex - this.beginIndex);
        System.arraycopy(this.ordinates, this.beginIndex, copy.ordinates, 0, dimension);
        System.arraycopy(this.ordinates, this.beginIndex + d, copy.ordinates, dimension, dimension);
        copy.crs = this.crs;
        return copy;
    }
}

