/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;

public class GeoHashCoder
implements Serializable {
    private static final long serialVersionUID = 9162259764027168776L;
    private Format format = Format.BASE32;
    private byte precision = (byte)12;
    private transient char[] buffer;

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        ArgumentChecks.ensureNonNull("format", (Object)format);
        this.format = format;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        ArgumentChecks.ensureBetween("precision", 1, 255, precision);
        this.precision = (byte)precision;
        this.buffer = null;
    }

    public String encode(double longitude, double latitude) {
        byte[] encoding = this.format.encoding;
        int highestOneBit = this.format.highestOneBit;
        char[] geohash = this.buffer;
        if (geohash == null) {
            this.buffer = geohash = new char[this.precision & 0xFF];
        }
        boolean isEven = true;
        double xmin = -180.0;
        double ymin = -90.0;
        double xmax = 180.0;
        double ymax = 90.0;
        int ch = 0;
        int bit = highestOneBit;
        int i = 0;
        while (i < geohash.length) {
            double mid;
            if (isEven) {
                mid = (xmin + xmax) / 2.0;
                if (longitude > mid) {
                    ch |= bit;
                    xmin = mid;
                } else {
                    xmax = mid;
                }
            } else {
                mid = (ymin + ymax) / 2.0;
                if (latitude > mid) {
                    ch |= bit;
                    ymin = mid;
                } else {
                    ymax = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if ((bit >>>= 1) != 0) continue;
            geohash[i++] = (char)encoding[ch];
            bit = highestOneBit;
            ch = 0;
        }
        return new String(geohash);
    }

    public String encode(DirectPosition position) {
        ArgumentChecks.ensureDimensionMatches("position", 2, position);
        return this.encode(position.getOrdinate(0), position.getOrdinate(1));
    }

    public DirectPosition decode(String geohash) throws ParseException {
        int nc;
        int length = geohash.length();
        int highestOneBit = this.format.highestOneBit;
        byte[] decodingLowerCase = this.format.decodingLowerCase;
        byte[] decodingUpperCase = this.format.decodingUpperCase;
        boolean isEven = true;
        double xmin = -180.0;
        double ymin = -90.0;
        double xmax = 180.0;
        double ymax = 90.0;
        for (int i = 0; i < length; i += nc) {
            int c = geohash.codePointAt(i);
            nc = Character.charCount(c);
            if (c >= 48 && c <= 57) {
                c -= 48;
            } else if ((c = c >= 97 && c <= 122 ? decodingLowerCase[c - 97] : (c >= 65 && c <= 90 ? decodingUpperCase[c - 65] : 0)) == 0) {
                throw new ParseException(Errors.format((short)125, "GeoHash", geohash, geohash.substring(i, i + nc)), i);
            }
            int mask = highestOneBit;
            do {
                double mid;
                if (isEven) {
                    mid = (xmin + xmax) / 2.0;
                    if ((c & mask) != 0) {
                        xmin = mid;
                    } else {
                        xmax = mid;
                    }
                } else {
                    mid = (ymin + ymax) / 2.0;
                    if ((c & mask) != 0) {
                        ymin = mid;
                    } else {
                        ymax = mid;
                    }
                }
                boolean bl = isEven = !isEven;
            } while ((mask >>>= 1) != 0);
        }
        return new DirectPosition2D((xmin + xmax) / 2.0, (ymin + ymax) / 2.0);
    }

    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int highestOneBit, byte[] encoding) {
            this.highestOneBit = highestOneBit;
            this.encoding = encoding;
            byte[] decoding = new byte[26];
            for (int i = 10; i < encoding.length; i = (int)((byte)(i + 1))) {
                decoding[encoding[i] - 97] = i;
            }
            this.decodingLowerCase = decoding;
            this.decodingUpperCase = decoding;
        }
    }
}

