/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.distance.DistanceUtils;
import org.apache.sis.distance.LatLonPointRadius;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;

public class QuadTree {
    private static final double EARTH_MIN_X = 0.0;
    private static final double EARTH_MIN_Y = 0.0;
    private static final double EARTH_MAX_X = 360.0;
    private static final double EARTH_MAX_Y = 180.0;
    private static final double EARTH_MID_X = 180.0;
    private static final double EARTH_MID_Y = 90.0;
    private static final double[] xf = new double[]{-0.25, 0.25, -0.25, 0.25};
    private static final double[] yf = new double[]{0.25, 0.25, -0.25, -0.25};
    private QuadTreeNode root;
    private int size = 0;
    private int nodeSize = 0;
    private int maxDepth;
    private int capacity;

    public QuadTree(int capacity, int maxDepth) {
        this.capacity = capacity;
        this.maxDepth = maxDepth;
        this.root = new QuadTreeNode(NodeType.GRAY, this.nodeSize);
    }

    public QuadTree() {
        this.capacity = 0;
        this.maxDepth = 0;
        this.root = new QuadTreeNode(NodeType.GRAY, this.nodeSize);
    }

    public boolean insert(QuadTreeData data) {
        if (this.insert(data, this.root)) {
            ++this.size;
            return true;
        }
        return false;
    }

    private Quadrant compare(QuadTreeData data, double x, double y) {
        if (data.getX() < x) {
            if (data.getY() < y) {
                return Quadrant.SW;
            }
            return Quadrant.NW;
        }
        if (data.getY() < y) {
            return Quadrant.SE;
        }
        return Quadrant.NE;
    }

    private boolean insert(QuadTreeData data, QuadTreeNode root) {
        int currentDepth = 0;
        QuadTreeNode r = root;
        double x = 180.0;
        double y = 90.0;
        double lx = 360.0;
        double ly = 180.0;
        QuadTreeNode t = r;
        Quadrant q = this.compare(data, x, y);
        ++currentDepth;
        while (t.getChild(q) != null && t.getChild(q).getNodeType() == NodeType.GRAY) {
            t = t.getChild(q);
            q = this.compare(data, x += xf[q.index()] * (lx /= 2.0), y += yf[q.index()] * (ly /= 2.0));
            if (++currentDepth <= this.maxDepth) continue;
            return false;
        }
        if (t.getChild(q) == null) {
            QuadTreeNode newlyCreated = new QuadTreeNode(++this.nodeSize, this.capacity);
            newlyCreated.addData(data);
            t.setChild(newlyCreated, q);
        } else {
            QuadTreeNode u = t.getChild(q);
            if (u.getCount() < this.capacity) {
                u.addData(data);
                return true;
            }
            QuadTreeData[] originalData = u.getData();
            if (!this.maxDepthExceeded(originalData, data, x, y, lx, ly, q, currentDepth)) {
                t.setChild(new QuadTreeNode(NodeType.GRAY, u.getId()), q);
                t = t.getChild(q);
                x += xf[q.index()] * lx;
                lx /= 2.0;
                y += yf[q.index()] * ly;
                ly /= 2.0;
                q = this.compare(data, x, y);
                if (++currentDepth > this.maxDepth) {
                    return false;
                }
                while (this.isSimilarQuad(originalData, data, x, y, q)) {
                    t.setChild(new QuadTreeNode(NodeType.GRAY, ++this.nodeSize), q);
                    t = t.getChild(q);
                    q = this.compare(data, x += xf[q.index()] * (lx /= 2.0), y += yf[q.index()] * (ly /= 2.0));
                    if (++currentDepth <= this.maxDepth) continue;
                    return false;
                }
                if (t.getChild(q) == null) {
                    QuadTreeNode newlyCreated = new QuadTreeNode(++this.nodeSize, this.capacity);
                    newlyCreated.addData(data);
                    t.setChild(newlyCreated, q);
                } else {
                    t.getChild(q).addData(data);
                }
                for (int i = 0; i < originalData.length; ++i) {
                    Quadrant uq = this.compare(originalData[i], x, y);
                    if (t.getChild(uq) == null) {
                        QuadTreeNode newlyCreated = new QuadTreeNode(++this.nodeSize, this.capacity);
                        newlyCreated.addData(originalData[i]);
                        t.setChild(newlyCreated, uq);
                        continue;
                    }
                    t.getChild(uq).addData(originalData[i]);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean maxDepthExceeded(QuadTreeData[] originalData, QuadTreeData toBeAddedData, double originalX, double originalY, double originalLX, double originalLY, Quadrant originalQ, int depth) {
        int currentDepth = depth;
        double x = originalX;
        double lx = originalLX;
        double y = originalY;
        double ly = originalLY;
        Quadrant q = originalQ;
        x += xf[q.index()] * lx;
        lx /= 2.0;
        y += yf[q.index()] * ly;
        ly /= 2.0;
        q = this.compare(toBeAddedData, x, y);
        if (++currentDepth > this.maxDepth) {
            return true;
        }
        while (this.isSimilarQuad(originalData, toBeAddedData, x, y, q)) {
            q = this.compare(toBeAddedData, x += xf[q.index()] * (lx /= 2.0), y += yf[q.index()] * (ly /= 2.0));
            if (++currentDepth <= this.maxDepth) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilarQuad(QuadTreeData[] originalData, QuadTreeData newNode, double x, double y, Quadrant q) {
        Quadrant quad = this.compare(originalData[0], x, y);
        if (q != quad) {
            return false;
        }
        for (int i = 1; i < originalData.length; ++i) {
            if (this.compare(originalData[i], x, y) == quad) continue;
            return false;
        }
        return true;
    }

    public List<QuadTreeData> queryByPointRadius(DirectPosition2D point, double radiusKM) {
        LatLonPointRadius pr = new LatLonPointRadius(point, radiusKM);
        return this.queryByPointRadius(point, radiusKM, this.root, new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0), pr.getRectangularRegionApproximation(360));
    }

    private List<QuadTreeData> queryByPointRadius(DirectPosition2D point, double radiusKM, QuadTreeNode node, Rectangle2D nodeRegion, Rectangle2D searchRegion) {
        ArrayList<QuadTreeData> matches = new ArrayList<QuadTreeData>();
        if (node == null) {
            return matches;
        }
        if (node.getNodeType() != NodeType.GRAY) {
            if (node.getNodeType() == NodeType.WHITE) {
                return matches;
            }
            QuadTreeData[] data = node.getData();
            for (int i = 0; i < node.getCount(); ++i) {
                if (!(DistanceUtils.getHaversineDistance(data[i].getLatLon().y, data[i].getLatLon().x, point.y, point.x) <= radiusKM)) continue;
                matches.add(data[i]);
            }
            return matches;
        }
        Rectangle2D.Double swRectangle = new Rectangle2D.Double(nodeRegion.getX(), nodeRegion.getY(), nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double seRectangle = new Rectangle2D.Double(nodeRegion.getX() + nodeRegion.getWidth() / 2.0, nodeRegion.getY(), nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double nwRectangle = new Rectangle2D.Double(nodeRegion.getX(), nodeRegion.getY() + nodeRegion.getHeight() / 2.0, nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double neRectangle = new Rectangle2D.Double(nodeRegion.getX() + nodeRegion.getWidth() / 2.0, nodeRegion.getY() + nodeRegion.getHeight() / 2.0, nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        if (swRectangle.intersects(searchRegion)) {
            List<QuadTreeData> swMatches = this.queryByPointRadius(point, radiusKM, node.getChild(Quadrant.SW), swRectangle, searchRegion);
            for (QuadTreeData q : swMatches) {
                matches.add(q);
            }
        }
        if (seRectangle.intersects(searchRegion)) {
            List<QuadTreeData> seMatches = this.queryByPointRadius(point, radiusKM, node.getChild(Quadrant.SE), seRectangle, searchRegion);
            for (QuadTreeData q : seMatches) {
                matches.add(q);
            }
        }
        if (nwRectangle.intersects(searchRegion)) {
            List<QuadTreeData> nwMatches = this.queryByPointRadius(point, radiusKM, node.getChild(Quadrant.NW), nwRectangle, searchRegion);
            for (QuadTreeData q : nwMatches) {
                matches.add(q);
            }
        }
        if (neRectangle.intersects(searchRegion)) {
            List<QuadTreeData> neMatches = this.queryByPointRadius(point, radiusKM, node.getChild(Quadrant.NE), neRectangle, searchRegion);
            for (QuadTreeData q : neMatches) {
                matches.add(q);
            }
        }
        return matches;
    }

    public List<QuadTreeData> queryByBoundingBox(Envelope2D searchRegion) {
        Rectangle2D.Double[] rectArray;
        for (Rectangle2D.Double r : rectArray = searchRegion.toRectangles()) {
            r.x += 180.0;
            r.y += 90.0;
        }
        if (rectArray.length == 1) {
            return this.queryByBoundingBox(rectArray[0]);
        }
        if (rectArray.length == 2) {
            List<QuadTreeData> firstMatches = this.queryByBoundingBox(rectArray[0]);
            List<QuadTreeData> secondMatches = this.queryByBoundingBox(rectArray[1]);
            for (QuadTreeData q : secondMatches) {
                if (firstMatches.contains(q)) continue;
                firstMatches.add(q);
            }
            return firstMatches;
        }
        return null;
    }

    private List<QuadTreeData> queryByBoundingBox(Rectangle2D searchRegion) {
        return this.queryByBoundingBox(this.root, new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0), searchRegion);
    }

    private List<QuadTreeData> queryByBoundingBox(QuadTreeNode node, Rectangle2D nodeRegion, Rectangle2D searchRegion) {
        ArrayList<QuadTreeData> matches = new ArrayList<QuadTreeData>();
        if (node == null) {
            return matches;
        }
        if (node.getNodeType() != NodeType.GRAY) {
            if (node.getNodeType() == NodeType.WHITE) {
                return matches;
            }
            QuadTreeData[] data = node.getData();
            for (int i = 0; i < node.getCount(); ++i) {
                if (!searchRegion.contains(data[i].getX(), data[i].getY())) continue;
                matches.add(data[i]);
            }
            return matches;
        }
        Rectangle2D.Double swRectangle = new Rectangle2D.Double(nodeRegion.getX(), nodeRegion.getY(), nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double seRectangle = new Rectangle2D.Double(nodeRegion.getX() + nodeRegion.getWidth() / 2.0, nodeRegion.getY(), nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double nwRectangle = new Rectangle2D.Double(nodeRegion.getX(), nodeRegion.getY() + nodeRegion.getHeight() / 2.0, nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        Rectangle2D.Double neRectangle = new Rectangle2D.Double(nodeRegion.getX() + nodeRegion.getWidth() / 2.0, nodeRegion.getY() + nodeRegion.getHeight() / 2.0, nodeRegion.getWidth() / 2.0, nodeRegion.getHeight() / 2.0);
        if (swRectangle.intersects(searchRegion)) {
            List<QuadTreeData> swMatches = this.queryByBoundingBox(node.getChild(Quadrant.SW), swRectangle, searchRegion);
            for (QuadTreeData q : swMatches) {
                matches.add(q);
            }
        }
        if (seRectangle.intersects(searchRegion)) {
            List<QuadTreeData> seMatches = this.queryByBoundingBox(node.getChild(Quadrant.SE), seRectangle, searchRegion);
            for (QuadTreeData q : seMatches) {
                matches.add(q);
            }
        }
        if (nwRectangle.intersects(searchRegion)) {
            List<QuadTreeData> nwMatches = this.queryByBoundingBox(node.getChild(Quadrant.NW), nwRectangle, searchRegion);
            for (QuadTreeData q : nwMatches) {
                matches.add(q);
            }
        }
        if (neRectangle.intersects(searchRegion)) {
            List<QuadTreeData> neMatches = this.queryByBoundingBox(node.getChild(Quadrant.NE), neRectangle, searchRegion);
            for (QuadTreeData q : neMatches) {
                matches.add(q);
            }
        }
        return matches;
    }

    public int size() {
        return this.size;
    }

    final QuadTreeNode getRoot() {
        return this.root;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setNodeSize(int nodeSize) {
        this.nodeSize = nodeSize;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getDepth() {
        return this.maxDepth;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setDepth(int depth) {
        this.maxDepth = depth;
    }
}

