/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTree;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;

public class QuadTreeWriter {
    public static void writeTreeToFile(QuadTree tree, String directory) {
        QuadTreeWriter.createIdxDir(directory);
        QuadTreeWriter.writeTreeConfigsToFile(tree, directory);
        QuadTreeWriter.writeNodeToFile(tree.getRoot(), directory);
    }

    private static void createIdxDir(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            System.out.println("[INFO] Creating qtree idx dir: [" + directory + "]");
            new File(directory).mkdirs();
        }
    }

    private static void writeTreeConfigsToFile(QuadTree tree, String directory) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(directory + "tree_config.txt"));
            writer.write("capacity;" + tree.getCapacity() + ";depth;" + tree.getDepth());
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeNodeToFile(QuadTreeNode node, String directory) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(directory + "node_" + node.getId() + ".txt"));
            if (node.getNodeType() == NodeType.GRAY) {
                if (node.getChild(Quadrant.NW) != null) {
                    writer.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.NW, node.getChild(Quadrant.NW)));
                    writer.newLine();
                }
                if (node.getChild(Quadrant.NE) != null) {
                    writer.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.NE, node.getChild(Quadrant.NE)));
                    writer.newLine();
                }
                if (node.getChild(Quadrant.SW) != null) {
                    writer.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.SW, node.getChild(Quadrant.SW)));
                    writer.newLine();
                }
                if (node.getChild(Quadrant.SE) != null) {
                    writer.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.SE, node.getChild(Quadrant.SE)));
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (node.getNodeType() == NodeType.GRAY) {
            if (node.getChild(Quadrant.NW) != null && node.getChild(Quadrant.NW).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(node.getChild(Quadrant.NW), directory);
            }
            if (node.getChild(Quadrant.NE) != null && node.getChild(Quadrant.NE).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(node.getChild(Quadrant.NE), directory);
            }
            if (node.getChild(Quadrant.SW) != null && node.getChild(Quadrant.SW).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(node.getChild(Quadrant.SW), directory);
            }
            if (node.getChild(Quadrant.SE) != null && node.getChild(Quadrant.SE).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(node.getChild(Quadrant.SE), directory);
            }
        }
    }

    private static String getQuadTreeDataString(Quadrant quadrant, QuadTreeNode node) {
        StringBuffer str = new StringBuffer();
        str.append(quadrant.index());
        str.append(':');
        str.append(node.getNodeType().toString());
        str.append(':');
        str.append(node.getId());
        str.append(':');
        str.append(node.getCapacity());
        str.append(':');
        QuadTreeData[] data = node.getData();
        for (int i = 0; i < node.getCount(); ++i) {
            str.append(data[i].getLatLon().y);
            str.append(';');
            str.append(data[i].getLatLon().x);
            str.append(';');
            str.append(data[i].getFileName());
            str.append(':');
        }
        return str.substring(0, str.length() - 1);
    }
}

