/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.io.Serializable;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class Column
extends TableColumn<Class<?>>
implements Serializable {
    private static final long serialVersionUID = -6297242452383159294L;
    static final Column SOURCE = new Column(false);
    static final Column TARGET = new Column(true);
    private final boolean target;

    private Column(boolean target) {
        super(Class.class, target ? "target" : "source");
        this.target = target;
    }

    @Override
    public InternationalString getHeader() {
        return Vocabulary.formatInternational(this.target ? (short)14 : 50);
    }

    private Object readResolve() {
        return this.target ? TARGET : SOURCE;
    }

    static TreeTable createTable() {
        return new DefaultTreeTable(TARGET, SOURCE);
    }

    static void toTree(ObjectConverter<?, ?> converter, TreeTable.Node addTo) {
        TreeTable.Node node = addTo.newChild();
        node.setValue(SOURCE, converter.getSourceClass());
        node.setValue(TARGET, converter.getTargetClass());
    }

    static String format(TreeTable table) {
        TreeTableFormat format = new TreeTableFormat(null, null);
        format.setColumnSeparatorPattern("?[\u00a0]\u00a0\u2190\u00a0");
        return format.format(table);
    }
}

