/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.internal.converter.ArrayConverter;
import org.apache.sis.internal.converter.ClassPair;
import org.apache.sis.internal.converter.Column;
import org.apache.sis.internal.converter.FallbackConverter;
import org.apache.sis.internal.converter.IdentityConverter;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

public class ConverterRegistry {
    private final Map<ClassPair<?, ?>, ObjectConverter<?, ?>> converters = new LinkedHashMap();
    private boolean isInitialized;

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            this.converters.clear();
            this.isInitialized = false;
        }
    }

    private <S, T> ObjectConverter<? super S, ? extends T> get(ClassPair<S, T> key) {
        assert (Thread.holdsLock(this.converters));
        return key.cast(this.converters.get(key));
    }

    private <S, T> void put(ClassPair<S, T> key, ObjectConverter<? super S, ? extends T> converter) {
        assert (key.getClass() == ClassPair.class);
        assert (key.cast(converter) != null) : converter;
        assert (Thread.holdsLock(this.converters));
        if (converter instanceof SystemConverter && converter.getSourceClass() == key.sourceClass && converter.getTargetClass() == key.targetClass) {
            this.converters.remove(key);
            key = (SystemConverter)converter;
        }
        this.converters.put(key, converter);
    }

    private static <S, T> ObjectConverter<S, T> findEquals(ObjectConverter<S, T> converter, ObjectConverter<S, ? extends T> existing) {
        if (converter instanceof FallbackConverter) {
            FallbackConverter fc = (FallbackConverter)converter;
            if ((converter = ConverterRegistry.findEquals(fc, fc.primary)) == null) {
                converter = ConverterRegistry.findEquals(fc, fc.fallback);
            }
        } else {
            converter = converter.equals(existing) ? existing : null;
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <S, T> ObjectConverter<S, T> findEquals(SystemConverter<S, T> converter) {
        ObjectConverter<S, T> existing;
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            existing = this.get(converter);
        }
        if (existing != null && existing.getSourceClass() == converter.getSourceClass()) {
            return ConverterRegistry.findEquals(converter, existing);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, T> void register(ObjectConverter<S, T> converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (converter instanceof FallbackConverter) {
            FallbackConverter fc = (FallbackConverter)converter;
            this.register(fc.primary);
            this.register(fc.fallback);
            return;
        }
        Class<S> sourceClass = converter.getSourceClass();
        Class<T> targetClass = converter.getTargetClass();
        Class<?> stopAt = Classes.findCommonClass(sourceClass, targetClass);
        ArgumentChecks.ensureNonNull("sourceClass", sourceClass);
        ArgumentChecks.ensureNonNull("targetClass", targetClass);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.initialize();
            }
            for (Class<T> i = targetClass; i != null && i != stopAt; i = i.getSuperclass()) {
                this.register(new ClassPair<S, T>(sourceClass, i), converter);
            }
            for (Class<T> i : Classes.getAllInterfaces(targetClass)) {
                if (i.isAssignableFrom(sourceClass) || Cloneable.class.isAssignableFrom(i) || sourceClass == Number.class && Comparable.class.isAssignableFrom(i) || sourceClass == String.class && Iterable.class.isAssignableFrom(i) || i.isAssignableFrom(sourceClass)) continue;
                this.register(new ClassPair<S, T>(sourceClass, i), converter);
            }
        }
    }

    private <S, T> void register(ClassPair<S, T> key, ObjectConverter<S, ? extends T> converter) {
        ObjectConverter<S, T> existing = this.get(key);
        if (existing != null) {
            if (existing.equals(converter)) {
                return;
            }
            assert (converter.getSourceClass() == key.sourceClass);
            if (existing.getSourceClass() == key.sourceClass) {
                boolean newIsExact;
                boolean oldIsExact = ConverterRegistry.isExactlyFor(existing, key.targetClass);
                if (oldIsExact & !(newIsExact = ConverterRegistry.isExactlyFor(converter, key.targetClass))) {
                    return;
                }
                if (newIsExact == oldIsExact) {
                    converter = FallbackConverter.merge(existing, converter);
                    assert (key.targetClass.isAssignableFrom(converter.getTargetClass())) : converter;
                }
            }
        }
        this.put(key, converter);
    }

    private static boolean isExactlyFor(ObjectConverter<?, ?> converter, Class<?> targetClass) {
        if (converter.getTargetClass() != targetClass) {
            return false;
        }
        if (converter instanceof FallbackConverter) {
            FallbackConverter fc = (FallbackConverter)converter;
            return ConverterRegistry.isExactlyFor(fc.primary, targetClass) && ConverterRegistry.isExactlyFor(fc.fallback, targetClass);
        }
        return true;
    }

    public <S, T> ObjectConverter<S, T> findExact(Class<S> sourceClass, Class<T> targetClass) throws UnconvertibleObjectException {
        ObjectConverter<S, T> candidate = this.find(sourceClass, targetClass);
        if (candidate.getSourceClass() == sourceClass && candidate.getTargetClass() == targetClass) {
            return candidate;
        }
        throw new UnconvertibleObjectException(Errors.format((short)3, sourceClass, targetClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, T> ObjectConverter<? super S, ? extends T> find(Class<S> sourceClass, Class<T> targetClass) throws UnconvertibleObjectException {
        ClassPair<S, T> key = new ClassPair<S, T>(sourceClass, targetClass);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            Class<?> targetComponent;
            ObjectConverter<S, T> converter = this.get(key);
            if (converter != null) {
                return converter;
            }
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.initialize();
                converter = this.get(key);
                if (converter != null) {
                    return converter;
                }
            }
            ClassPair<S, T> candidate = key;
            while ((candidate = candidate.parentSource()) != null) {
                converter = this.get(candidate);
                if (converter == null) continue;
                this.put(key, converter);
                return converter;
            }
            converter = this.createConverter(sourceClass, targetClass);
            if (converter != null) {
                this.put(key, converter);
                return converter;
            }
            Class<?> sourceComponent = sourceClass.getComponentType();
            if (sourceComponent != null && (targetComponent = targetClass.getComponentType()) != null) {
                converter = new ArrayConverter<S, T>(sourceClass, targetClass, this.find(Numbers.primitiveToWrapper(sourceComponent), Numbers.primitiveToWrapper(targetComponent)));
                this.put(key, converter);
                return converter;
            }
        }
        throw new UnconvertibleObjectException(Errors.format((short)3, sourceClass, targetClass));
    }

    protected <S, T> ObjectConverter<S, T> createConverter(Class<S> sourceClass, Class<T> targetClass) {
        if (targetClass.isAssignableFrom(sourceClass)) {
            return new IdentityConverter<T, S>(sourceClass, targetClass, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeTable table = Column.createTable();
        TreeTable.Node root = table.getRoot();
        root.setValue(Column.TARGET, this.getClass());
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            for (Map.Entry<ClassPair<?, ?>, ObjectConverter<?, ?>> entry : this.converters.entrySet()) {
                TreeTable.Node addTo = root;
                ClassPair<?, ?> key = entry.getKey();
                ObjectConverter<?, ?> converter = entry.getValue();
                if (converter.getSourceClass() != key.sourceClass || converter.getTargetClass() != key.targetClass) {
                    addTo = addTo.newChild();
                    addTo.setValue(Column.SOURCE, key.sourceClass);
                    addTo.setValue(Column.TARGET, key.targetClass);
                }
                if (converter instanceof FallbackConverter) {
                    ((FallbackConverter)converter).toTree(addTo.newChild(), true);
                    continue;
                }
                Column.toTree(converter, addTo);
            }
        }
        return Column.format(table);
    }
}

