/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public final class AttributeConvention
extends Static {
    private static final GenericName NAMESPACE;
    public static final LocalName ID_PROPERTY;
    public static final LocalName DEFAULT_GEOMETRY_PROPERTY;
    public static final LocalName ENVELOPE_PROPERTY;
    public static final LocalName CRS_CHARACTERISTIC;
    public static final LocalName MAXIMAL_LENGTH_CHARACTERISTIC;
    public static final LocalName VALID_VALUES_CHARACTERISTIC;

    private AttributeConvention() {
    }

    public static boolean contains(GenericName name) {
        if (name == null) {
            return false;
        }
        GenericName scope = name instanceof ScopedName ? ((ScopedName)name).path().toFullyQualifiedName() : name.scope().name();
        return NAMESPACE.equals(scope);
    }

    public static boolean isGeometryAttribute(AbstractIdentifiedType type) {
        while (type instanceof AbstractOperation) {
            type = ((AbstractOperation)type).getResult();
        }
        return type instanceof DefaultAttributeType && Geometries.isKnownType(((DefaultAttributeType)type).getValueClass());
    }

    public static boolean characterizedByCRS(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, CRS_CHARACTERISTIC.toString(), CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(Object attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(attribute, CRS_CHARACTERISTIC.toString());
    }

    public static boolean characterizedByMaximalLength(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, MAXIMAL_LENGTH_CHARACTERISTIC.toString(), Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(Object attribute) {
        return (Integer)AttributeConvention.getCharacteristic(attribute, MAXIMAL_LENGTH_CHARACTERISTIC.toString());
    }

    private static boolean hasCharacteristic(AbstractIdentifiedType type, String name, Class<?> valueClass) {
        DefaultAttributeType<?> at;
        while (type instanceof AbstractOperation) {
            type = ((AbstractOperation)type).getResult();
        }
        if (type instanceof DefaultAttributeType && (at = ((DefaultAttributeType)type).characteristics().get(name)) != null) {
            return valueClass.isAssignableFrom(at.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(Object attribute, String name) {
        if (attribute instanceof AbstractAttribute) {
            Object value;
            AbstractAttribute<?> at = ((AbstractAttribute)attribute).characteristics().get(name);
            if (at != null && (value = at.getValue()) != null) {
                return value;
            }
            DefaultAttributeType<?> type = ((AbstractAttribute)attribute).getType().characteristics().get(name);
            if (type != null) {
                return type.getDefaultValue();
            }
        }
        return null;
    }

    static {
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        NAMESPACE = factory.createGenericName(null, "Apache", "SIS");
        NameSpace ns = factory.createNameSpace(NAMESPACE, null);
        ID_PROPERTY = factory.createLocalName(ns, "@identifier");
        DEFAULT_GEOMETRY_PROPERTY = factory.createLocalName(ns, "@geometry");
        ENVELOPE_PROPERTY = factory.createLocalName(ns, "@envelope");
        CRS_CHARACTERISTIC = factory.createLocalName(ns, "@crs");
        MAXIMAL_LENGTH_CHARACTERISTIC = factory.createLocalName(ns, "@maximalLength");
        VALID_VALUES_CHARACTERISTIC = factory.createLocalName(ns, "@validValues");
    }
}

