/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

abstract class Builder<T extends Builder<T>> {
    final Map<String, Object> identification = new HashMap<String, Object>(4);

    Builder() {
    }

    public T clear() {
        this.identification.clear();
        return (T)this;
    }

    abstract GenericName name(String var1, String var2);

    public T setName(String localPart) {
        ArgumentChecks.ensureNonEmpty("localPart", localPart);
        return this.setName(this.name(null, localPart));
    }

    public T setName(String scope, String localPart) {
        ArgumentChecks.ensureNonEmpty("localPart", localPart);
        if (scope == null) {
            scope = "";
        }
        return this.setName(this.name(scope, localPart));
    }

    public T setName(GenericName name) {
        ArgumentChecks.ensureNonNull("name", name);
        this.identification.put("name", name);
        return (T)this;
    }

    public GenericName getName() {
        return (GenericName)this.identification.get("name");
    }

    final String getDisplayName() {
        GenericName name = this.getName();
        return name != null ? name.toString() : Vocabulary.getResources(this.identification).getString((short)65);
    }

    public T setDefinition(CharSequence definition) {
        this.identification.put("definition", definition);
        return (T)this;
    }

    public T setDesignation(CharSequence designation) {
        this.identification.put("designation", designation);
        return (T)this;
    }

    public T setDescription(CharSequence description) {
        this.identification.put("description", description);
        return (T)this;
    }
}

