/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.FieldType;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Builder;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;

public class FeatureTypeBuilder
extends Builder<FeatureTypeBuilder> {
    private final NameFactory nameFactory;
    private final List<Property<?>> properties;
    private final List<DefaultFeatureType> superTypes;
    private boolean isAbstract;
    private String defaultScope;
    private int defaultMinimumOccurs;
    private int defaultMaximumOccurs;
    private String idPrefix;
    private String idSuffix;
    private String idDelimiter;
    private final List<Property<?>> idAttributes;
    private Property<?> defaultGeometry;

    public FeatureTypeBuilder() {
        this(DefaultFactories.forBuildin(NameFactory.class));
    }

    public FeatureTypeBuilder(NameFactory factory) {
        this.nameFactory = factory;
        this.properties = new ArrayList();
        this.superTypes = new ArrayList<DefaultFeatureType>();
        this.idAttributes = new ArrayList();
        this.idDelimiter = ":";
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
    }

    @Override
    public FeatureTypeBuilder clear() {
        super.clear();
        this.properties.clear();
        this.superTypes.clear();
        this.idAttributes.clear();
        this.idDelimiter = ":";
        this.idPrefix = null;
        this.idSuffix = null;
        this.isAbstract = false;
        this.defaultGeometry = null;
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
        return this;
    }

    public FeatureTypeBuilder setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public FeatureTypeBuilder setSuperTypes(DefaultFeatureType ... parents) {
        ArgumentChecks.ensureNonNull("parents", parents);
        this.superTypes.clear();
        this.superTypes.addAll(Arrays.asList(parents));
        return this;
    }

    public FeatureTypeBuilder setDefaultScope(String scope) {
        this.defaultScope = scope;
        return this;
    }

    public FeatureTypeBuilder setDefaultCardinality(int minimumOccurs, int maximumOccurs) {
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(this.errors().getString((short)41, minimumOccurs, maximumOccurs));
        }
        this.defaultMinimumOccurs = minimumOccurs;
        this.defaultMaximumOccurs = maximumOccurs;
        return this;
    }

    public FeatureTypeBuilder setIdentifierDelimiters(String delimiter, String prefix, String suffix) {
        ArgumentChecks.ensureNonEmpty("delimiter", delimiter);
        this.idDelimiter = delimiter;
        this.idPrefix = prefix;
        this.idSuffix = suffix;
        return this;
    }

    public <V> Property<V> addIdentifier(Class<V> valueClass) {
        this.ensureAttributeType(valueClass);
        Property<V> property = new Property<V>(valueClass);
        this.idAttributes.add(property);
        this.properties.add(property);
        return property;
    }

    public <V> Property<V> addDefaultGeometry(Class<V> valueClass) {
        this.ensureAttributeType(valueClass);
        if (!Geometries.isKnownType(valueClass)) {
            throw new IllegalArgumentException(this.errors().getString((short)127, valueClass));
        }
        if (this.defaultGeometry != null) {
            throw new IllegalStateException(this.errors().getString((short)156, this.getDisplayName(), AttributeConvention.DEFAULT_GEOMETRY_PROPERTY));
        }
        Property<V> property = new Property<V>(valueClass);
        this.defaultGeometry = property;
        this.properties.add(property);
        return property;
    }

    public <V> Property<V> addAttribute(Class<V> valueClass) {
        this.ensureAttributeType(valueClass);
        Property<V> property = new Property<V>(valueClass);
        this.properties.add(property);
        return property;
    }

    private void ensureAttributeType(Class<?> valueClass) {
        if (valueClass == null) {
            throw new NullArgumentException(this.errors().getString((short)95, "valueClass"));
        }
        if (AbstractFeature.class.isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException(this.errors().getString((short)31, "valueClass", valueClass));
        }
    }

    public Property<AbstractFeature> addAssociation(DefaultFeatureType type) {
        ArgumentChecks.ensureNonNull("type", type);
        Property<AbstractFeature> property = new Property<AbstractFeature>(AbstractFeature.class, DefaultFeatureType.class, type);
        this.properties.add(property);
        return property;
    }

    public Property<AbstractFeature> addAssociation(GenericName type) {
        ArgumentChecks.ensureNonNull("type", type);
        Property<AbstractFeature> property = new Property<AbstractFeature>(AbstractFeature.class, GenericName.class, type);
        this.properties.add(property);
        return property;
    }

    public DefaultFeatureType build() throws IllegalStateException {
        int numSynthetic;
        AbstractIdentifiedType[] identifierTypes;
        int numSpecified = this.properties.size();
        if (this.idAttributes.isEmpty()) {
            identifierTypes = null;
            numSynthetic = 0;
        } else {
            identifierTypes = new AbstractIdentifiedType[this.idAttributes.size()];
            numSynthetic = 1;
        }
        if (this.defaultGeometry != null) {
            numSynthetic += 2;
        }
        AbstractIdentifiedType[] propertyTypes = new AbstractIdentifiedType[numSynthetic + numSpecified];
        int i = 0;
        int j = numSynthetic;
        while (i < numSpecified) {
            AbstractIdentifiedType instance;
            Property<?> builder = this.properties.get(i);
            propertyTypes[j] = instance = builder.build();
            int id = this.idAttributes.indexOf(builder);
            if (id >= 0) {
                identifierTypes[id] = instance;
            }
            if (builder == this.defaultGeometry) {
                AbstractIdentifiedType geom;
                if (AttributeConvention.DEFAULT_GEOMETRY_PROPERTY.equals(instance.getName())) {
                    propertyTypes = ArraysExt.remove(propertyTypes, j--, 1);
                    geom = instance;
                } else {
                    geom = FeatureOperations.link(FeatureTypeBuilder.name(AttributeConvention.DEFAULT_GEOMETRY_PROPERTY), instance);
                }
                propertyTypes[numSynthetic - 1] = geom;
            }
            ++i;
            ++j;
        }
        if (this.defaultGeometry != null) {
            try {
                propertyTypes[numSynthetic - 2] = FeatureOperations.envelope(FeatureTypeBuilder.name(AttributeConvention.ENVELOPE_PROPERTY), null, propertyTypes);
            }
            catch (FactoryException e) {
                throw new IllegalStateException(e);
            }
        }
        if (identifierTypes != null) {
            propertyTypes[0] = FeatureOperations.compound(FeatureTypeBuilder.name(AttributeConvention.ID_PROPERTY), this.idDelimiter, this.idPrefix, this.idSuffix, identifierTypes);
        }
        return new DefaultFeatureType(this.identification, this.isAbstract, this.superTypes.toArray(new DefaultFeatureType[this.superTypes.size()]), propertyTypes);
    }

    private static Map<String, ?> name(GenericName name) {
        return Collections.singletonMap("name", name);
    }

    @Override
    final GenericName name(String scope, String localPart) {
        if (scope == null) {
            scope = this.defaultScope;
        }
        if (scope == null || scope.isEmpty()) {
            return this.nameFactory.createLocalName(null, localPart);
        }
        return this.nameFactory.createGenericName(null, scope, localPart);
    }

    final Errors errors() {
        return Errors.getResources(this.identification);
    }

    public final class Characteristic<V>
    extends Builder<Characteristic<V>> {
        private final Class<V> valueClass;
        V defaultValue;

        Characteristic(Class<V> valueClass) {
            this.valueClass = valueClass;
        }

        @Override
        final GenericName name(String scope, String localPart) {
            return FeatureTypeBuilder.this.name(scope, localPart);
        }

        final void set(Object value) {
            this.setDefaultValue(this.valueClass.cast(value));
        }

        public Characteristic<V> setDefaultValue(V value) {
            this.defaultValue = value;
            return this;
        }

        final DefaultAttributeType<V> build() {
            return new DefaultAttributeType<V>(this.identification, this.valueClass, 0, 1, this.defaultValue, new DefaultAttributeType[0]);
        }
    }

    public final class Property<V>
    extends Builder<Property<V>> {
        private final Class<V> valueClass;
        private V defaultValue;
        private int minimumOccurs;
        private int maximumOccurs;
        private final List<Characteristic<?>> characteristics;

        Property(Class<V> valueClass) {
            this.valueClass = valueClass;
            this.minimumOccurs = FeatureTypeBuilder.this.defaultMinimumOccurs;
            this.maximumOccurs = FeatureTypeBuilder.this.defaultMaximumOccurs;
            this.characteristics = new ArrayList();
        }

        <C> Property(Class<V> valueClass, Class<C> typeClass, C type) {
            this.valueClass = valueClass;
            this.minimumOccurs = FeatureTypeBuilder.this.defaultMinimumOccurs;
            this.maximumOccurs = FeatureTypeBuilder.this.defaultMaximumOccurs;
            this.characteristics = Collections.singletonList(new Characteristic<C>(typeClass).setDefaultValue(type));
        }

        @Override
        final GenericName name(String scope, String localPart) {
            return FeatureTypeBuilder.this.name(scope, localPart);
        }

        public Property<V> setCardinality(int minimumOccurs, int maximumOccurs) {
            if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
                throw new IllegalArgumentException(FeatureTypeBuilder.this.errors().getString((short)41, minimumOccurs, maximumOccurs));
            }
            this.minimumOccurs = minimumOccurs;
            this.maximumOccurs = maximumOccurs;
            return this;
        }

        public Property<V> setDefaultValue(V defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Property<V> setValidValues(V ... values) {
            return this.setCharacteristic(AttributeConvention.VALID_VALUES_CHARACTERISTIC, Set.class, CollectionsExt.immutableSet(false, values));
        }

        public Property<V> setMaximalLengthCharacteristic(Integer length) {
            return this.setCharacteristic(AttributeConvention.MAXIMAL_LENGTH_CHARACTERISTIC, Integer.class, length);
        }

        public Property<V> setCRSCharacteristic(CoordinateReferenceSystem crs) {
            return this.setCharacteristic(AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, crs);
        }

        private <C> Property<V> setCharacteristic(GenericName name, Class<C> type, C value) {
            for (Characteristic<?> characteristic : this.characteristics) {
                if (!name.equals(characteristic.identification.get("name"))) continue;
                characteristic.set(value);
                return this;
            }
            this.addCharacteristic(type).setDefaultValue(value).setName(name);
            return this;
        }

        public <C> Characteristic<C> addCharacteristic(Class<C> type) {
            if (this.valueClass == AbstractFeature.class) {
                throw new UnsupportedOperationException(FeatureTypeBuilder.this.errors().getString((short)141, this.valueClass));
            }
            ArgumentChecks.ensureNonNull("type", type);
            Characteristic<C> characteristic = new Characteristic<C>(type);
            this.characteristics.add(characteristic);
            return characteristic;
        }

        final AbstractIdentifiedType build() {
            FieldType property;
            if (this.valueClass == AbstractFeature.class) {
                Object type = CollectionsExt.first(this.characteristics).defaultValue;
                property = type instanceof DefaultFeatureType ? new DefaultAssociationRole(this.identification, (DefaultFeatureType)type, this.minimumOccurs, this.maximumOccurs) : new DefaultAssociationRole(this.identification, (GenericName)type, this.minimumOccurs, this.maximumOccurs);
            } else {
                DefaultAttributeType[] chrts = new DefaultAttributeType[this.characteristics.size()];
                for (int i = 0; i < chrts.length; ++i) {
                    chrts[i] = this.characteristics.get(i).build();
                }
                property = new DefaultAttributeType<V>(this.identification, this.valueClass, this.minimumOccurs, this.maximumOccurs, this.defaultValue, chrts);
            }
            return property;
        }
    }
}

