/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.Serializable;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public class IdentifierMapAdapter
extends AbstractMap<Citation, String>
implements IdentifierMap,
Serializable {
    private static final long serialVersionUID = -1445849218952061605L;
    public static final IdentifierMap EMPTY = new IdentifierMapAdapter(Collections.<Identifier>emptySet());
    public final Collection<Identifier> identifiers;

    public IdentifierMapAdapter(Collection<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    static int specialCase(Object authority) {
        if (authority == IdentifierSpace.HREF) {
            return 2;
        }
        return -1;
    }

    private URI getHRef() {
        Object link;
        Identifier identifier = this.getIdentifier(IdentifierSpace.XLINK);
        if (identifier instanceof SpecializedIdentifier && (link = ((SpecializedIdentifier)identifier).value) instanceof XLink) {
            return ((XLink)link).getHRef();
        }
        return null;
    }

    private static String toString(Object value) {
        return value != null ? value.toString() : null;
    }

    boolean isModifiable() {
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.identifiers.isEmpty();
    }

    @Override
    public final int size() {
        HashSet<Citation> done = new HashSet<Citation>(Containers.hashMapCapacity(this.identifiers.size()));
        for (Identifier identifier : this.identifiers) {
            if (identifier == null) continue;
            done.add(identifier.getAuthority());
        }
        return done.size();
    }

    @Override
    public final boolean containsValue(Object code) {
        if (code instanceof String) {
            for (Identifier identifier : this.identifiers) {
                if (identifier == null || !code.equals(identifier.getCode())) continue;
                return true;
            }
            return code.equals(IdentifierMapAdapter.toString(this.getHRef()));
        }
        return false;
    }

    @Override
    public final boolean containsKey(Object authority) {
        if (authority instanceof Citation) {
            if (this.getIdentifier((Citation)authority) != null) {
                return true;
            }
            switch (IdentifierMapAdapter.specialCase(authority)) {
                case 2: {
                    return this.getHRef() != null;
                }
            }
        }
        return false;
    }

    final Identifier getIdentifier(Citation authority) {
        for (Identifier identifier : this.identifiers) {
            if (identifier == null || !Objects.equals(authority, identifier.getAuthority())) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public final <T> T getSpecialized(IdentifierSpace<T> authority) {
        Identifier identifier = this.getIdentifier(authority);
        if (identifier instanceof SpecializedIdentifier) {
            return ((SpecializedIdentifier)identifier).value;
        }
        switch (IdentifierMapAdapter.specialCase(authority)) {
            case 2: {
                return (T)this.getHRef();
            }
        }
        return null;
    }

    @Override
    public final String get(Object authority) {
        if (authority instanceof Citation) {
            Identifier identifier = this.getIdentifier((Citation)authority);
            if (identifier != null) {
                return identifier.getCode();
            }
            switch (IdentifierMapAdapter.specialCase(authority)) {
                case 2: {
                    return IdentifierMapAdapter.toString(this.getHRef());
                }
            }
        }
        return null;
    }

    @Override
    public String remove(Object authority) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String put(Citation authority, String code) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> authority, T value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Citation, String>> entrySet() {
        return new SetOfUnknownSize<Map.Entry<Citation, String>>(){

            @Override
            public void clear() throws UnsupportedOperationException {
                IdentifierMapAdapter.this.clear();
            }

            @Override
            public boolean isEmpty() {
                return IdentifierMapAdapter.this.isEmpty();
            }

            @Override
            public int size() {
                return IdentifierMapAdapter.this.size();
            }

            @Override
            public Iterator<Map.Entry<Citation, String>> iterator() {
                return new Iter(IdentifierMapAdapter.this.identifiers, IdentifierMapAdapter.this.isModifiable());
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(50).append('{');
        for (Map.Entry<Citation, String> entry : this.entrySet()) {
            if (buffer.length() != 1) {
                buffer.append(", ");
            }
            SpecializedIdentifier.format(buffer, entry.getKey(), entry.getValue());
        }
        return buffer.append('}').toString();
    }

    private static final class Iter
    extends HashMap<Citation, Boolean>
    implements Iterator<Map.Entry<Citation, String>> {
        private Iterator<? extends Identifier> identifiers;
        private transient Map.Entry<Citation, String> next;
        private transient Citation authority;
        private final boolean isModifiable;

        Iter(Collection<? extends Identifier> identifiers, boolean isModifiable) {
            super(Containers.hashMapCapacity(identifiers.size()));
            this.identifiers = identifiers.iterator();
            this.isModifiable = isModifiable;
        }

        private void toNext() {
            Iterator<? extends Identifier> it = this.identifiers;
            if (it != null) {
                while (it.hasNext()) {
                    Identifier identifier = it.next();
                    if (identifier == null) continue;
                    Citation authority = identifier.getAuthority();
                    Boolean state = this.put(authority, Boolean.FALSE);
                    if (state == null) {
                        this.next = identifier instanceof IdentifierMapEntry ? (IdentifierMapEntry)identifier : new IdentifierMapEntry.Immutable(authority, identifier.getCode());
                        this.authority = authority;
                        return;
                    }
                    if (!state.booleanValue()) continue;
                    it.remove();
                }
                this.identifiers = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.toNext();
            }
            return this.identifiers != null;
        }

        @Override
        public Map.Entry<Citation, String> next() throws NoSuchElementException {
            Map.Entry<Citation, String> entry = this.next;
            if (entry == null) {
                this.toNext();
                entry = this.next;
            }
            this.next = null;
            if (this.identifiers == null) {
                throw new NoSuchElementException();
            }
            return entry;
        }

        @Override
        public void remove() throws IllegalStateException {
            if (!this.isModifiable) {
                throw new UnsupportedOperationException();
            }
            Iterator<? extends Identifier> it = this.identifiers;
            if (it == null || this.next != null) {
                throw new IllegalStateException();
            }
            it.remove();
            this.put(this.authority, Boolean.TRUE);
        }
    }
}

