/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.system.SystemListener;

public abstract class TypeRegistration {
    private static Reference<JAXBContext> context;

    protected TypeRegistration() {
    }

    public abstract void getTypes(Collection<Class<?>> var1);

    private static Class<?>[] defaultClassesToBeBound() {
        ArrayList types = new ArrayList();
        for (TypeRegistration t : ServiceLoader.load(TypeRegistration.class)) {
            t.getTypes(types);
        }
        return types.toArray(new Class[types.size()]);
    }

    public static synchronized JAXBContext getSharedContext() throws JAXBException {
        JAXBContext instance;
        Reference<JAXBContext> c = context;
        if (c != null && (instance = c.get()) != null) {
            return instance;
        }
        instance = JAXBContext.newInstance((Class[])TypeRegistration.defaultClassesToBeBound());
        context = new WeakReference<JAXBContext>(instance);
        return instance;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<TypeRegistration> clazz = TypeRegistration.class;
                synchronized (TypeRegistration.class) {
                    context = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

