/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gmd.PT_FreeText;
import org.apache.sis.internal.jaxb.gmx.Anchor;
import org.apache.sis.util.CharSequences;
import org.apache.sis.xml.XLink;
import org.opengis.util.InternationalString;

public final class CharSequenceAdapter
extends XmlAdapter<GO_CharacterString, CharSequence> {
    private CharSequenceAdapter() {
    }

    public CharSequence unmarshal(GO_CharacterString value) {
        return value != null ? value.toCharSequence() : null;
    }

    public GO_CharacterString marshal(CharSequence value) {
        return CharSequenceAdapter.wrap(value);
    }

    static GO_CharacterString wrap(CharSequence value) {
        Context context;
        XLink linkage;
        String key;
        PT_FreeText ft;
        if (value instanceof String) {
            return CharSequenceAdapter.wrap(Context.current(), value, (String)value);
        }
        if (value instanceof InternationalString && (ft = PT_FreeText.create((InternationalString)value)) != null) {
            return ft;
        }
        if ((value = CharSequences.trimWhitespaces(value)) == null || value.length() == 0) {
            return null;
        }
        if (!(value instanceof Anchor) && (key = CharSequences.trimWhitespaces(value.toString())) != null && !key.isEmpty() && (linkage = Context.resolver(context = Context.current()).anchor(context, value, key)) != null) {
            value = linkage instanceof Anchor ? (Anchor)linkage : new Anchor(linkage, key);
        }
        return new GO_CharacterString(value);
    }

    public static GO_CharacterString wrap(Context context, Object object, String string) {
        CharSequence text = CharSequenceAdapter.value(context, object, string);
        return text != null ? new GO_CharacterString(text) : null;
    }

    public static CharSequence value(Context context, Object object, String string) {
        if ((string = CharSequences.trimWhitespaces(string)) == null || string.isEmpty()) {
            return null;
        }
        XLink linkage = Context.resolver(context).anchor(context, object, string);
        if (linkage != null) {
            if (linkage instanceof Anchor) {
                return (Anchor)linkage;
            }
            return new Anchor(linkage, string);
        }
        return string;
    }
}

