/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.jaxb.gmd.CodeListUID;
import org.apache.sis.internal.jaxb.gmd.Country;
import org.apache.sis.internal.jaxb.gmd.LanguageCode;
import org.apache.sis.internal.jaxb.gmd.PT_FreeText;
import org.apache.sis.internal.jaxb.gmx.Anchor;
import org.apache.sis.internal.jaxb.gmx.FileName;
import org.apache.sis.internal.jaxb.gmx.MimeFileType;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;

@XmlType(name="CharacterString_PropertyType")
@XmlSeeAlso(value={PT_FreeText.class, LanguageCode.class, Country.class})
public class GO_CharacterString {
    public static final byte MIME_TYPE = 1;
    public static final byte FILENAME = 2;
    private static final byte ANCHOR = 3;
    private static final byte ENUM = 4;
    private CharSequence text;
    public byte type;

    private static String nameOf(byte type) {
        switch (type) {
            case 0: {
                return "CharacterString";
            }
            case 1: {
                return "MimeFileType";
            }
            case 2: {
                return "FileName";
            }
            case 3: {
                return "Anchor";
            }
            case 4: {
                return "ControlledVocabulary";
            }
        }
        throw new AssertionError(type);
    }

    protected GO_CharacterString() {
    }

    protected GO_CharacterString(CharSequence text) {
        this.text = text;
        if (text instanceof Anchor) {
            this.type = (byte)3;
        } else if (Types.forCodeTitle(text) != null) {
            this.type = (byte)4;
        }
    }

    private void setText(CharSequence value, byte property) {
        if ((value = CharSequences.trimWhitespaces(value)) != null && value.length() != 0) {
            if (this.text != null && !value.equals(this.text)) {
                byte discarded = this.type;
                boolean noset = false;
                if (discarded > property) {
                    discarded = property;
                    property = this.type;
                    noset = true;
                }
                Context.warningOccured(Context.current(), this.getClass(), "setText", Messages.class, (short)2, GO_CharacterString.nameOf(discarded), GO_CharacterString.nameOf(property));
                if (noset) {
                    return;
                }
            }
            this.text = value;
            this.type = property;
        }
    }

    @XmlElements(value={@XmlElement(type=String.class, name="CharacterString"), @XmlElement(type=Anchor.class, name="Anchor", namespace="http://www.isotc211.org/2005/gmx"), @XmlElement(type=FileName.class, name="FileName", namespace="http://www.isotc211.org/2005/gmx"), @XmlElement(type=MimeFileType.class, name="MimeFileType", namespace="http://www.isotc211.org/2005/gmx")})
    private Object getValue() {
        switch (this.type) {
            case 0: {
                return StringAdapter.toString(this.text);
            }
            case 2: {
                return new FileName(this.text.toString());
            }
            case 1: {
                return new MimeFileType(this.text.toString());
            }
            case 3: {
                return this.text;
            }
        }
        return null;
    }

    private void setValue(Object value) {
        if (value instanceof Anchor) {
            this.setText((Anchor)value, (byte)3);
        } else if (value instanceof FileName) {
            this.setText(value.toString(), (byte)2);
        } else if (value instanceof MimeFileType) {
            this.setText(value.toString(), (byte)1);
        } else {
            this.setText((CharSequence)value, (byte)0);
        }
    }

    @XmlAnyElement
    private Object getCodeList() {
        if (this.type != 4) {
            return null;
        }
        CodeList<?> code = Types.forCodeTitle(this.text);
        String name = Types.getListName(code);
        String namespace = name.startsWith("MD_") || name.startsWith("CI_") || name.startsWith("DS_") ? "http://www.isotc211.org/2005/gmd" : (name.startsWith("MI_") ? "http://www.isotc211.org/2005/gmi" : (name.startsWith("SV_") || name.equals("DCPList") ? "http://www.isotc211.org/2005/srv" : (name.startsWith("CS_") || name.startsWith("CD_") || name.startsWith("SC_") ? "http://www.opengis.net/gml/3.2" : "")));
        return new JAXBElement(new QName(namespace, name), CodeListUID.class, (Object)new CodeListUID(Context.current(), code));
    }

    private void setCodeList(Object value) {
        Element e = (Element)value;
        if (e.getNodeType() == 1) {
            String attribute;
            Class<?> ct = Types.forStandardName(e.getLocalName());
            if (ct != null && CodeList.class.isAssignableFrom(ct) && !(attribute = e.getAttribute("codeListValue")).isEmpty()) {
                this.text = Types.getCodeTitle(Types.forCodeName(ct, attribute, true));
                this.type = (byte)4;
                return;
            }
            Context.warningOccured(Context.current(), GO_CharacterString.class, "setCodeList", Errors.class, (short)118, e.getNodeName());
        }
    }

    protected CharSequence toCharSequence() {
        CharSequence text = CharSequences.trimWhitespaces(this.text);
        if (text != null && (text.length() != 0 || text instanceof Anchor)) {
            return text;
        }
        return null;
    }

    public final String toString() {
        CharSequence text = this.text;
        return text != null ? text.toString() : null;
    }
}

