/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.gml.CodeType;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

abstract class NameAdapter<ValueType extends NameAdapter<ValueType, BoundType>, BoundType extends GenericName>
extends XmlAdapter<ValueType, BoundType> {
    GenericName name;

    NameAdapter() {
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.name != null) {
            throw new IllegalStateException(Errors.format((short)131, "name"));
        }
    }

    @XmlElementRef
    public final CodeType getCodeType() {
        CodeType code;
        GenericName name = this.name;
        if (name instanceof LocalName) {
            if (name instanceof TypeName || name instanceof MemberName) {
                return null;
            }
            code = new CodeType.LocalName();
        } else if (name instanceof ScopedName) {
            code = new CodeType.ScopedName();
        } else {
            return null;
        }
        code.setName(name);
        return code;
    }

    public final void setCodeType(CodeType code) throws IllegalStateException {
        this.ensureUndefined();
        if (code != null) {
            this.name = code.getName();
        }
    }

    @XmlElementRef
    public final DefaultLocalName getNameType() {
        GenericName name = this.name;
        if (name instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)name);
        }
        if (name instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)name);
        }
        return null;
    }

    public final void setNameType(DefaultLocalName value) throws IllegalStateException {
        this.ensureUndefined();
        this.name = value;
    }
}

