/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmd.CodeListAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;

@XmlType(name="CodeList", propOrder={"codeList", "codeListValue", "codeSpace"})
public final class CodeListUID {
    @XmlAttribute(required=true)
    public String codeList;
    @XmlAttribute(required=true)
    public String codeListValue;
    @XmlAttribute
    public String codeSpace;
    @XmlValue
    public String value;

    private static String schema(Context context, String identifier) {
        return Context.schema(context, "gmd", "http://schemas.opengis.net/iso/19139/20070417/").append("resources/Codelist/gmxCodelists.xml").append('#').append(identifier).toString();
    }

    CodeListUID() {
    }

    public CodeListUID(Context context, String codeList, String codeListValue, String codeSpace, String value) {
        this.codeList = CodeListUID.schema(context, codeList);
        this.codeListValue = codeListValue;
        this.codeSpace = codeSpace;
        this.value = value;
    }

    public CodeListUID(Context context, CodeList<?> code) {
        String classID = Types.getListName(code);
        String fieldID = Types.getCodeName(code);
        this.codeList = CodeListUID.schema(context, classID);
        Locale locale = context.getLocale();
        if (locale != null) {
            String key = classID + '.' + fieldID;
            try {
                this.value = ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale, CodeList.class.getClassLoader()).getString(key);
            }
            catch (MissingResourceException e) {
                Context.warningOccured(context, CodeListAdapter.class, "marshal", e, false);
            }
        }
        if (this.value != null) {
            this.codeSpace = Context.converter(context).toLanguageCode(context, locale);
        } else {
            this.value = Types.getCodeLabel(code);
        }
        this.codeListValue = fieldID;
    }

    public String toString() {
        String id = this.codeListValue;
        if (id == null) {
            id = this.value;
        }
        return id;
    }
}

