/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jdk7.Objects;

final class LocalisedCharacterString {
    private static final String PREFIX = "#locale-";
    Locale locale;
    @XmlValue
    String text;

    LocalisedCharacterString() {
    }

    LocalisedCharacterString(Locale locale, String text) {
        this.locale = locale;
        this.text = text;
    }

    @XmlAttribute(name="locale", required=true)
    public String getLocale() {
        if (this.locale == null) {
            return null;
        }
        Context context = Context.current();
        return PREFIX.concat(Context.converter(context).toLanguageCode(context, this.locale));
    }

    public void setLocale(String localeId) {
        if (localeId != null) {
            Context context = Context.current();
            this.locale = Context.converter(context).toLocale(context, localeId.substring(localeId.indexOf(45) + 1));
        } else {
            this.locale = null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.text);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalisedCharacterString)) {
            return false;
        }
        LocalisedCharacterString that = (LocalisedCharacterString)object;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.text, that.text);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(80).append(this.getClass().getSimpleName()).append('[').append(this.getLocale());
        if (this.text != null) {
            buffer.append(", \u201c").append(this.text).append('\u201d');
        }
        return buffer.append(']').toString();
    }
}

