/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gmd.LocalisedCharacterString;
import org.apache.sis.internal.jaxb.gmd.TextGroup;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.DefaultInternationalString;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.util.InternationalString;

@XmlType(name="PT_FreeText_PropertyType")
public final class PT_FreeText
extends GO_CharacterString {
    @XmlElementWrapper(name="PT_FreeText")
    @XmlElement(required=true)
    private TextGroup[] textGroup;

    private PT_FreeText() {
    }

    private PT_FreeText(String text, TextGroup[] textGroup) {
        super(text);
        this.textGroup = textGroup;
    }

    public static PT_FreeText create(InternationalString text) {
        if (text instanceof DefaultInternationalString) {
            DefaultInternationalString df = (DefaultInternationalString)text;
            Set<Locale> locales = df.getLocales();
            TextGroup[] textGroup = new TextGroup[locales.size()];
            int n = 0;
            for (Locale locale : locales) {
                if (locale == null || locale.equals(Locale.ROOT)) continue;
                textGroup[n++] = new TextGroup(locale, text.toString(locale));
            }
            if (n != 0) {
                Context context = Context.current();
                return new PT_FreeText(df.toString(context != null ? context.getLocale() : null), ArraysExt.resize(textGroup, n));
            }
        }
        return null;
    }

    private boolean contains(String search) {
        TextGroup[] textGroup = this.textGroup;
        if (textGroup != null) {
            for (TextGroup group : textGroup) {
                LocalisedCharacterString[] localised;
                if (group == null || (localised = group.localized) == null) continue;
                for (LocalisedCharacterString candidate : localised) {
                    if (!search.equals(candidate.text)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected CharSequence toCharSequence() {
        String defaultValue = this.toString();
        if (defaultValue != null && this.contains(defaultValue)) {
            defaultValue = null;
        }
        DefaultInternationalString i18n = null;
        TextGroup[] textGroup = this.textGroup;
        if (textGroup != null) {
            for (TextGroup group : textGroup) {
                LocalisedCharacterString[] localised;
                if (group == null || (localised = group.localized) == null) continue;
                for (LocalisedCharacterString text : localised) {
                    if (text == null) continue;
                    if (i18n == null) {
                        i18n = new DefaultInternationalString(defaultValue);
                    }
                    i18n.add(text.locale, text.text);
                }
            }
        }
        if (i18n == null && defaultValue != null) {
            return new SimpleInternationalString(defaultValue);
        }
        return i18n;
    }
}

