/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.gmd.LocalisedCharacterString;
import org.apache.sis.internal.jdk7.JDK7;

final class TextGroup {
    @XmlElement(name="LocalisedCharacterString")
    protected LocalisedCharacterString[] localized;

    public TextGroup() {
    }

    TextGroup(Locale locale, String text) {
        this.localized = new LocalisedCharacterString[]{new LocalisedCharacterString(locale, text)};
    }

    public String toString() {
        String lineSeparator = JDK7.lineSeparator();
        StringBuilder buffer = new StringBuilder(160).append(this.getClass().getSimpleName()).append(lineSeparator);
        if (this.localized != null) {
            int corner = 0;
            for (LocalisedCharacterString string : this.localized) {
                corner = buffer.length();
                buffer.append("\u251c\u2500 ").append(string).append(lineSeparator);
            }
            if (corner != 0) {
                buffer.setCharAt(corner, '\u2514');
            }
        }
        return buffer.toString();
    }
}

