/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.net.URISyntaxException;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;

@XmlType(name="MeasureType")
public final class Measure {
    @XmlValue
    public double value;
    public Unit<?> unit;
    public boolean asXPointer;

    public Measure() {
        this.value = Double.NaN;
    }

    public Measure(double value, Unit<?> unit) {
        this.value = value;
        this.unit = unit;
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, this.asXPointer, false);
    }

    public static String getUOM(Unit<?> unit, boolean asXPointer, boolean inAxis) {
        Integer code;
        if (!asXPointer && (code = Units.getEpsgCode(unit, inAxis)) != null) {
            return "urn:ogc:def:uom:EPSG::" + code;
        }
        if (unit == null || unit.equals(Unit.ONE)) {
            return "";
        }
        if (unit.equals(NonSI.PIXEL)) {
            return "pixel";
        }
        return Context.schema(Context.current(), "gmd", "http://schemas.opengis.net/iso/19139/20070417/").append("resources/uom/gmxUom.xml").append("#xpointer(//*[@gml:id='").append(unit).append("'])").toString();
    }

    public void setUOM(String uom) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, uom);
    }

    public <Q extends Quantity> Unit<Q> getUnit(Class<Q> type) {
        return this.unit != null ? this.unit.asType(type) : null;
    }

    public boolean setUnit(Unit<?> newUnit) {
        boolean changed = this.unit != null && !this.unit.equals(newUnit);
        this.unit = newUnit;
        return changed;
    }

    public static void missingUOM(Class<?> caller, String methodName) {
        Context.warningOccured(Context.current(), caller, methodName, Errors.class, (short)55, "uom", "Measure");
    }
}

