/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gts;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.sis.internal.geoapi.temporal.TemporalFactory;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.XmlUtilities;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public final class TM_PeriodDuration
extends PropertyType<TM_PeriodDuration, PeriodDuration> {
    public TM_PeriodDuration() {
    }

    private TM_PeriodDuration(PeriodDuration metadata) {
        super(metadata);
    }

    @Override
    protected TM_PeriodDuration wrap(PeriodDuration value) {
        return new TM_PeriodDuration(value);
    }

    @Override
    protected Class<PeriodDuration> getBoundType() {
        return PeriodDuration.class;
    }

    @XmlElement(name="TM_PeriodDuration")
    public Duration getElement() {
        if (this.metadata instanceof org.apache.sis.internal.geoapi.temporal.PeriodDuration) {
            try {
                DatatypeFactory factory = XmlUtilities.getDatatypeFactory();
                org.apache.sis.internal.geoapi.temporal.PeriodDuration metadata = (org.apache.sis.internal.geoapi.temporal.PeriodDuration)this.metadata;
                BigInteger years = null;
                InternationalString value = metadata.getYears();
                if (value != null) {
                    years = new BigInteger(value.toString());
                }
                BigInteger months = null;
                value = metadata.getMonths();
                if (value != null) {
                    months = new BigInteger(value.toString());
                }
                BigInteger days = null;
                value = metadata.getDays();
                if (value != null) {
                    days = new BigInteger(value.toString());
                }
                BigInteger hours = null;
                value = metadata.getHours();
                if (value != null) {
                    hours = new BigInteger(value.toString());
                }
                BigInteger minutes = null;
                value = metadata.getMinutes();
                if (value != null) {
                    minutes = new BigInteger(value.toString());
                }
                BigDecimal seconds = null;
                value = metadata.getSeconds();
                if (value != null) {
                    seconds = new BigDecimal(value.toString());
                }
                return factory.newDuration(true, years, months, days, hours, minutes, seconds);
            }
            catch (DatatypeConfigurationException e) {
                TM_PeriodDuration.warningOccured("getElement", e);
            }
        }
        return null;
    }

    public void setElement(Duration duration) {
        this.metadata = null;
        if (duration != null) {
            try {
                TemporalFactory factory = TemporalUtilities.getTemporalFactory();
                SimpleInternationalString years = null;
                int value = duration.getYears();
                if (value != 0) {
                    years = new SimpleInternationalString(Integer.toString(value));
                }
                SimpleInternationalString months = null;
                value = duration.getMonths();
                if (value != 0) {
                    months = new SimpleInternationalString(Integer.toString(value));
                }
                InternationalString weeks = null;
                SimpleInternationalString days = null;
                value = duration.getDays();
                if (value != 0) {
                    days = new SimpleInternationalString(Integer.toString(value));
                }
                SimpleInternationalString hours = null;
                value = duration.getHours();
                if (value != 0) {
                    hours = new SimpleInternationalString(Integer.toString(value));
                }
                SimpleInternationalString minutes = null;
                value = duration.getMinutes();
                if (value != 0) {
                    minutes = new SimpleInternationalString(Integer.toString(value));
                }
                SimpleInternationalString seconds = null;
                value = duration.getSeconds();
                if (value != 0) {
                    seconds = new SimpleInternationalString(Integer.toString(value));
                }
                this.metadata = factory.createPeriodDuration(years, months, weeks, days, hours, minutes, seconds);
            }
            catch (UnsupportedOperationException e) {
                TM_PeriodDuration.warningOccured("setElement", e);
            }
        }
    }

    private static void warningOccured(String methodName, Exception e) {
        if (!e.getMessage().contains("sis-temporal")) {
            Context.warningOccured(Context.current(), TM_PeriodDuration.class, methodName, e, true);
        }
    }
}

