/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Set;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.metadata.direct.GO_MemberName;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.iso.Names;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.TypeName;

@XmlType(name="SV_Parameter_Type", namespace="http://www.isotc211.org/2005/srv", propOrder={"memberName", "description", "optionality", "repeatability", "valueType"})
@XmlRootElement(name="SV_Parameter", namespace="http://www.isotc211.org/2005/srv")
public final class ServiceParameter
extends SimpleIdentifiedObject
implements ParameterDescriptor {
    private static final long serialVersionUID = -5335736212313243889L;
    @XmlElement(required=true, name="name")
    @XmlJavaTypeAdapter(value=GO_MemberName.class)
    MemberName memberName;
    @XmlElement
    InternationalString description;
    public boolean optionality;
    @XmlElement(required=true)
    public boolean repeatability;
    private transient ParameterDescriptor descriptor;

    ServiceParameter() {
    }

    private ServiceParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
        this.memberName = ServiceParameter.getMemberName(parameter);
        this.optionality = parameter.getMinimumOccurs() > 0;
        this.repeatability = parameter.getMaximumOccurs() > 1;
    }

    public static ServiceParameter castOrCopy(ParameterDescriptor<?> parameter) {
        if (parameter == null || parameter instanceof ServiceParameter) {
            return (ServiceParameter)parameter;
        }
        return new ServiceParameter(parameter);
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameter) {
        if (parameter != null) {
            String code;
            Class<?> valueClass;
            ReferenceIdentifier id = parameter.getName();
            if (id instanceof MemberName) {
                return (MemberName)((Object)id);
            }
            for (GenericName alias : CollectionsExt.nonNull(parameter.getAlias())) {
                if (!(alias instanceof MemberName)) continue;
                return (MemberName)alias;
            }
            if (id != null && (valueClass = parameter.getValueClass()) != null && (code = id.getCode()) != null) {
                return Names.createMemberName(id.getCodeSpace(), ":", code, valueClass);
            }
        }
        return null;
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.memberName != null) {
            this.name = this.memberName instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)this.memberName) : new NameToIdentifier(this.memberName);
        }
        return this.name;
    }

    public Class<?> getValueClass() {
        return this.memberName != null ? Names.toClass(this.memberName.getAttributeType()) : null;
    }

    @XmlElement(name="valueType")
    final TypeName getValueType() {
        return this.memberName != null ? this.memberName.getAttributeType() : null;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @XmlElement(name="optionality", required=true)
    final String getOptionality() {
        return this.optionality ? "Optional" : "Mandatory";
    }

    final void setOptionality(String optional) {
        if (optional != null) {
            this.optionality = Boolean.parseBoolean(optional) || optional.equalsIgnoreCase("Optional");
        }
    }

    @Override
    public int getMinimumOccurs() {
        return this.optionality ? 0 : 1;
    }

    @Override
    public int getMaximumOccurs() {
        return this.repeatability ? Integer.MAX_VALUE : 1;
    }

    public Set<?> getValidValues() {
        return null;
    }

    public Comparable<?> getMinimumValue() {
        return null;
    }

    public Comparable<?> getMaximumValue() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Unit<?> getUnit() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterValue<?> createValue() {
        ParameterDescriptor<?> desc;
        ServiceParameter serviceParameter = this;
        synchronized (serviceParameter) {
            desc = this.descriptor;
            if (desc == null) {
                this.descriptor = desc = ReferencingServices.getInstance().toImplementation(this);
            }
        }
        return desc.createValue();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        ParameterDescriptor that;
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode) && object instanceof ParameterDescriptor && (that = (ParameterDescriptor)object).getUnit() == null && that.getDefaultValue() == null && that.getValueClass() == this.getValueClass()) {
            if (mode.isIgnoringMetadata()) {
                return Objects.equals(ServiceParameter.toString(this.getName()), ServiceParameter.toString(that.getName()));
            }
            return that.getMinimumOccurs() == this.getMinimumOccurs() && that.getMaximumOccurs() == this.getMaximumOccurs() && that.getValidValues() == null && that.getMinimumValue() == null && that.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

