/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;

@XmlType(name="CodeType")
public final class Code {
    @XmlValue
    String code;
    @XmlAttribute
    String codeSpace;

    Code() {
    }

    Code(ReferenceIdentifier identifier) {
        this.code = identifier.getCode();
        this.codeSpace = identifier.getCodeSpace();
        String version = identifier.getVersion();
        if (version != null) {
            StringBuilder buffer = new StringBuilder();
            if (this.codeSpace != null) {
                buffer.append(this.codeSpace);
            }
            this.codeSpace = buffer.append(':').append(version).toString();
        }
    }

    public ReferenceIdentifier getIdentifier() {
        String c = this.code;
        if (c == null) {
            return null;
        }
        Citation authority = null;
        String version = null;
        String cs = this.codeSpace;
        DefinitionURI parsed = DefinitionURI.parse(c);
        if (parsed != null && parsed.code != null) {
            authority = Citations.isEPSG(cs, parsed.authority) ? org.apache.sis.metadata.iso.citation.Citations.EPSG : org.apache.sis.metadata.iso.citation.Citations.fromName(cs);
            cs = parsed.authority;
            version = parsed.version;
            c = parsed.code;
        } else if (cs != null) {
            int s = cs.lastIndexOf(58);
            if (s >= 0) {
                version = cs.substring(s + 1);
                cs = cs.substring(0, s);
            }
            authority = org.apache.sis.metadata.iso.citation.Citations.fromName(cs);
        }
        return new NamedIdentifier(authority, cs, (CharSequence)c, version, null);
    }

    public static Code forIdentifiedObject(Class<?> type, Iterable<? extends ReferenceIdentifier> identifiers) {
        if (identifiers != null) {
            boolean isHTTP = false;
            boolean isEPSG = false;
            ReferenceIdentifier fallback = null;
            for (ReferenceIdentifier referenceIdentifier : identifiers) {
                String code = referenceIdentifier.getCode();
                if (code == null) continue;
                if (code.regionMatches(true, 0, "urn:", 0, 4)) {
                    return new Code(referenceIdentifier);
                }
                if (isHTTP) continue;
                isHTTP = code.regionMatches(true, 0, "http:", 0, 5);
                if (isHTTP) {
                    fallback = referenceIdentifier;
                    continue;
                }
                if (isEPSG || !(isEPSG = "EPSG".equalsIgnoreCase(referenceIdentifier.getCodeSpace())) && fallback != null) continue;
                fallback = referenceIdentifier;
            }
            if (fallback != null) {
                String urn;
                if (!isHTTP && (urn = NameMeaning.toURN(type, fallback.getCodeSpace(), fallback.getVersion(), fallback.getCode())) != null) {
                    Code code = new Code();
                    Citation authority = fallback.getAuthority();
                    if (isEPSG) {
                        code.codeSpace = "IOGP";
                        if (authority != null) {
                            for (Identifier identifier : authority.getIdentifiers()) {
                                String cs;
                                if (!"EPSG".equalsIgnoreCase(identifier.getCode()) || !(identifier instanceof ReferenceIdentifier) || (cs = ((ReferenceIdentifier)identifier).getCodeSpace()) == null) continue;
                                code.codeSpace = cs;
                                break;
                            }
                        }
                    } else {
                        code.codeSpace = Citations.getCodeSpace(authority);
                    }
                    code.code = urn;
                    return code;
                }
                return new Code(fallback);
            }
        }
        return null;
    }
}

