/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.sis.internal.jdk7.Path;

public final class DirectoryStream
implements Closeable,
Iterable<Path>,
FileFilter {
    private final File directory;
    private final Pattern pattern;

    DirectoryStream(File directory, String glob) {
        this.directory = directory;
        glob = glob.replace(".", "\\.");
        glob = glob.replace("?", ".");
        glob = glob.replace("*", ".*");
        this.pattern = Pattern.compile(glob);
    }

    @Override
    public Iterator<Path> iterator() {
        File[] files = this.directory.listFiles(this);
        Path[] paths = new Path[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = Path.castOrCopy(files[i]);
        }
        return Arrays.asList(paths).iterator();
    }

    @Override
    public boolean accept(File pathname) {
        return this.pattern.matcher(pathname.getName()).matches();
    }

    @Override
    public void close() throws IOException {
    }
}

