/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.sis.internal.jdk7.DirectoryStream;
import org.apache.sis.internal.jdk7.Path;

public final class Files {
    private Files() {
    }

    public static Path createDirectory(Path dir) throws IOException {
        if (!dir.mkdir()) {
            throw new IOException("Can not create directory: " + dir);
        }
        return dir;
    }

    public static boolean isDirectory(Path path) {
        return path.isDirectory();
    }

    public static boolean isRegularFile(Path path) {
        return path.isFile();
    }

    public static boolean isReadable(Path path) {
        return path.canRead();
    }

    public static boolean isWritable(Path path) {
        return path.canWrite();
    }

    public static boolean exists(Path path) {
        return path.exists();
    }

    public static DirectoryStream newDirectoryStream(Path dir, String glob) throws IOException {
        return new DirectoryStream(dir, glob);
    }

    public static InputStream newInputStream(Path path) throws IOException {
        return new FileInputStream(path);
    }

    public static BufferedReader newBufferedReader(Path path, Charset cs) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), cs.newDecoder()));
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset cs) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), cs.newEncoder()));
    }

    public static ByteChannel newByteChannel(File file, Set<?> options) throws IOException {
        String mode = "r";
        if (options != null) {
            if (options.contains("DSYNC")) {
                mode = "rwd";
            } else if (options.contains("SYNC")) {
                mode = "rws";
            } else if (options.contains("WRITE")) {
                mode = "rw";
            }
        }
        return new RandomAccessFile(file, mode).getChannel();
    }

    public static ByteChannel newByteChannel(Path path) throws IOException {
        return Files.newByteChannel(path, null);
    }
}

