/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.jdk7.AutoCloseable;

public final class JDK7 {
    private JDK7() {
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static boolean isBmpCodePoint(int c) {
        return c >= 0 && c <= 65535;
    }

    public static char highSurrogate(int c) {
        c -= 65536;
        c >>>= 10;
        return (char)(c += 55296);
    }

    public static char lowSurrogate(int c) {
        c &= 0x3FF;
        return (char)(c += 56320);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static boolean isAutoCloseable(Object object) {
        return object instanceof Closeable || object instanceof ImageInputStream || object instanceof Connection || object instanceof Statement || object instanceof ResultSet || object != null && object.getClass().isAnnotationPresent(AutoCloseable.class);
    }

    public static void close(Object object) throws Exception {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        } else if (object instanceof ImageInputStream) {
            ((ImageInputStream)object).close();
        } else if (object instanceof Connection) {
            ((Connection)object).close();
        } else if (object instanceof Statement) {
            ((Statement)object).close();
        } else if (object instanceof ResultSet) {
            ((ResultSet)object).close();
        } else {
            try {
                object.getClass().getMethod("close", null).invoke(object, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
    }
}

