/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.util.Arrays;

public final class Objects {
    private Objects() {
    }

    public static <T> T requireNonNull(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> T requireNonNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    public static boolean equals(Object o1, Object o2) {
        assert (o1 == null || !o1.getClass().isArray()) : o1;
        assert (o2 == null || !o2.getClass().isArray()) : o2;
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static boolean deepEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object1, (Object[])object2);
        }
        if (object1 instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object1, (double[])object2);
        }
        if (object1 instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object1, (float[])object2);
        }
        if (object1 instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object1, (long[])object2);
        }
        if (object1 instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object1, (int[])object2);
        }
        if (object1 instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object1, (short[])object2);
        }
        if (object1 instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object1, (byte[])object2);
        }
        if (object1 instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object1, (char[])object2);
        }
        if (object1 instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object1, (boolean[])object2);
        }
        return object1.equals(object2);
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        assert (!object.getClass().isArray()) : object;
        return object.hashCode();
    }
}

