/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk7;

import java.io.File;
import java.net.URI;

public final class Path
extends File {
    Path(String path) {
        super(path);
    }

    Path(URI path) throws IllegalArgumentException {
        super(path);
    }

    Path(File path, String other) {
        super(path, other);
    }

    public static Path castOrCopy(File file) {
        return file == null || file instanceof Path ? (Path)file : new Path(file.getPath());
    }

    public Path getFileName() {
        return new Path(this.getName());
    }

    public Path normalize() {
        return this;
    }

    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        return new Path(this, other.toString());
    }

    public Path resolve(String other) {
        return this.resolve(new Path(other));
    }

    public Path resolveSibling(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        return new Path(this.getParentFile(), other.toString());
    }

    public Path resolveSibling(String other) {
        return this.resolveSibling(new Path(other));
    }

    public Path relativize(Path other) {
        String start = this.getAbsolutePath();
        String full = other.getAbsolutePath();
        if (full.startsWith(start)) {
            int length = start.length();
            if (full.length() > length && full.charAt(length) == separatorChar) {
                return new Path(full.substring(length + 1));
            }
        }
        return other;
    }

    public URI toUri() {
        return this.toURI();
    }

    public Path toAbsolutePath() {
        return this.isAbsolute() ? this : new Path(this.getAbsolutePath());
    }
}

