/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.text.ParseException;
import java.util.Date;
import org.apache.sis.internal.jdk8.DateTimeException;
import org.apache.sis.internal.util.StandardDateFormat;

public final class Instant {
    private static final StandardDateFormat parser = new StandardDateFormat();
    private final long millis;

    private Instant(long millis) {
        this.millis = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instant parse(CharSequence text) {
        Date time;
        try {
            StandardDateFormat standardDateFormat = parser;
            synchronized (standardDateFormat) {
                time = parser.parse(text.toString());
            }
        }
        catch (ParseException e) {
            throw new DateTimeException(e.getMessage());
        }
        return new Instant(time.getTime());
    }

    public static Instant ofEpochMilli(long millis) {
        return new Instant(millis);
    }

    public long toEpochMilli() {
        return this.millis;
    }

    public Date toDate() {
        return new Date(this.millis);
    }
}

