/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.jdk7.Path;
import org.apache.sis.internal.jdk7.StandardCharsets;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.jdk8.Predicate;

public final class JDK8 {
    private static final AtomicReference<Calendar> CALENDAR = new AtomicReference();

    private JDK8() {
    }

    public static int compareUnsigned(int x, int y) {
        return JDK7.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    public static int toUnsignedInt(short x) {
        return x & 0xFFFF;
    }

    public static int toIntExact(long value) {
        int vi = (int)value;
        if ((long)vi != value) {
            throw new ArithmeticException();
        }
        return vi;
    }

    public static int multiplyExact(int x, int y) {
        return JDK8.toIntExact((long)x * (long)y);
    }

    public static double nextDown(double value) {
        return Math.nextAfter(value, Double.NEGATIVE_INFINITY);
    }

    public static <V> V getOrDefault(Map<?, V> map, Object key, V defaultValue) {
        V value = map.get(key);
        if (value == null && !map.containsKey(key)) {
            value = defaultValue;
        }
        return value;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        V previous = map.put(key, value);
        if (previous != null) {
            map.put(key, previous);
        }
        return previous;
    }

    public static <K, V> boolean remove(Map<K, V> map, Object key, Object value) {
        boolean c;
        V current = map.get(key);
        boolean bl = c = Objects.equals(current, value) && (current != null || map.containsKey(key));
        if (c) {
            map.remove(key);
        }
        return c;
    }

    public static <E> boolean removeIf(Collection<E> collection, Predicate<? super E> filter) {
        boolean changed = false;
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            if (!filter.test(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        V c = map.get(key);
        if (Objects.equals(c, oldValue) && (c != null || map.containsKey(key))) {
            map.put(key, newValue);
            return true;
        }
        return false;
    }

    public static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entry.setValue(function.apply(entry.getKey(), entry.getValue()));
        }
    }

    public static <K, V> V compute(ConcurrentMap<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        boolean success;
        do {
            Object oldValue;
            if ((newValue = remappingFunction.apply(key, oldValue = map.get(key))) != null) {
                if (oldValue != null) {
                    success = map.replace(key, oldValue, newValue);
                    continue;
                }
                success = map.putIfAbsent(key, newValue) == null;
                continue;
            }
            if (oldValue != null) {
                success = map.remove(key, oldValue);
                continue;
            }
            return null;
        } while (!success);
        return newValue;
    }

    public static Date parseDateTime(String date) throws IllegalArgumentException {
        return DatatypeConverter.parseDateTime((String)date).getTime();
    }

    public static String printDateTime(Date date) {
        Calendar calendar = CALENDAR.getAndSet(null);
        if (calendar == null) {
            calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        }
        calendar.setTime(date);
        String text = DatatypeConverter.printDateTime((Calendar)calendar);
        CALENDAR.set(calendar);
        return text;
    }

    public static BufferedReader newBufferedReader(Path path) throws IOException {
        return Files.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    public static BufferedWriter newBufferedWriter(Path path) throws IOException {
        return Files.newBufferedWriter(path, StandardCharsets.UTF_8);
    }
}

